package com.almworks.jira.structure.api.generator;

import com.atlassian.annotations.PublicSpi;

/**
 * <p>An implementor of this interface checks for an external change that may affect a built forest fragment.
 * It checks for changes those happened after the forest fragment had been generated.</p>
 * <p>Here is a basic implementation:</p>
 * <pre>
 *   state = collectState(); // Collect whatever is required to build a forest
 *   // Generate a forest based on the state
 *   context.addUpdateChecker(() -> !state.equals(collectState())); // If something has changed, the Structure has to regenerate the forest
 * </pre>
 * <p>If the forest fragment depends only on items those changes are reported to {@link com.almworks.jira.structure.api.item.ItemTracker ItemTracker}
 * you may consider to {@link com.almworks.jira.structure.api.generator.StructureGenerator.GenerationContext#addItemChangeFilter(ItemChangeFilter) addItemChangeFilter}.</p>
 * @see com.almworks.jira.structure.api.generator.StructureGenerator.GenerationContext#addUpdateChecker(UpdateChecker)
 */
@PublicSpi
public interface UpdateChecker {
  /**
   * Checks if there is any change that affects a generated forest fragment.
   * @return true the forest fragment is outdated and Structure has to regenerate the it.
   *         false if the fragment is still up to date.
   */
  boolean hasUpdate();
}
