package com.almworks.jira.structure.api.generator;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.PublicSpi;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

/**
 * <p>An implementor of this interfaces checks if any of changed items may affect a built forest fragment.
 * The implementor may detect only changes those are recorded to {@link com.almworks.jira.structure.api.item.ItemTracker}</p>
 * <p>Here is the basic implementation:</p>
 * <pre>
 *   return itemIds.stream().anyMatch(itemId ->
 *     // return true if a change of the item may affect the forest fragment
 *     );
 * </pre>
 * <p>If the forest fragment may depend on changes those are not reported to the {@link com.almworks.jira.structure.api.item.ItemTracker ItemTracker}
 * You have to implement {@link UpdateChecker}</p>
 * @see com.almworks.jira.structure.api.generator.StructureGenerator.GenerationContext#addItemChangeFilter(ItemChangeFilter)
 * @see com.almworks.jira.structure.api.generator.util.BasicItemChangeFilter
 */
@PublicSpi
public interface ItemChangeFilter {
  /**
   * Checks if any of changed items may affect the built forest.
   * @param itemIds set of changed items
   * @param context convenient methods to check an item
   * @return true if the forest fragment may be stale, Structure has to regenerate the forest.
   *         false if none of the changed item affects the fragment.
   */
  boolean accept(@NotNull Set<ItemIdentity> itemIds, @NotNull StructureGenerator.ItemChangeFilterContext context);
}
