package com.almworks.jira.structure.api.forest.raw;

import com.almworks.integers.LongList;
import org.jetbrains.annotations.NotNull;

/**
 * Used to iterate over a forest - see {@link Forest#visitParentChildrenUpwards}.
 *
 * @author Igor Sereda
 * @see Forest#visitParentChildrenUpwards
 */
public interface ForestParentChildrenVisitor {
  /**
   * Reports a pair of parent row and its children (direct sub-items). If a row has no children (it's a leaf),
   * then this method is called with empty <code>children</code> parameter.
   *
   * @param forest the iterated forest
   * @param parent parent row
   * @param children list of children
   * @return true if the iteration should continue, false to stop iterating and exit visiting
   * @see Forest#visitParentChildrenUpwards
   */
  boolean visit(@NotNull Forest forest, long parent, @NotNull LongList children);
}
