package com.almworks.jira.structure.api.error;

import com.atlassian.annotations.PublicApi;

/**
 * {@code StructureRuntimeException}, or its subclass, is thrown when a Structure service experiences an unexpected
 * error, which is not part of the service's contract.
 */
@PublicApi
public class StructureRuntimeException extends RuntimeException {
  public StructureRuntimeException(String message) {
    super(message);
  }

  public StructureRuntimeException(String message, Throwable cause) {
    super(message, cause);
  }

  public StructureRuntimeException(Throwable cause) {
    super(cause);
  }
}
