package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.row.StructureRow;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.Nullable;

/**
 * <p>The context interface for scanning attribute loaders.</p>
 *
 * @see ScanningAttributeLoader
 */
@PublicApi
public interface ScanningAttributeContext extends RowAttributeContext {
  /**
   * <p>Returns the depth of the row currently being loaded.</p>
   *
   * <p>Root elements have depth of {@code 0}. Super-root is never loaded with a scanning loader.</p>
   *
   * @return the depth of the row being loaded
   */
  int getDepth();

  /**
   * Returns the row that immediately precedes this row in the forest.
   * When calculating the very first row, returns {@code null} (and <strong>not</strong> the super-root!)
   *
   * @return preceding row
   */
  @Nullable
  StructureRow getPrecedingRow();

  /**
   * <p>Returns the depth of the row that immediately precedes this row in the forest. When calculating the very first row, returns {@code -1}.</p>
   *
   * <p>Root elements have depth of {@code 0}. Super-root is never loaded with a scanning loader.</p>
   *
   * @return the depth of the preceding row
   */
  int getPrecedingRowDepth();
}
