package com.almworks.jira.structure.api.row;

import com.almworks.jira.structure.api.item.CoreItemTypes;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public final class ShallowRow implements StructureRow {
  private final long myRowId;

  @NotNull
  private final ItemIdentity myItemId;

  private final long mySemantics;

  public ShallowRow(long rowId, @NotNull ItemIdentity itemId, long semantics) {
    StructureRows.validateForestRowId(rowId);
    myRowId = rowId;
    myItemId = itemId;
    mySemantics = semantics;
  }

  @Override
  public long getRowId() {
    return myRowId;
  }

  @NotNull
  @Override
  public ItemIdentity getItemId() {
    return myItemId;
  }

  @Override
  public long getSemantics() {
    return mySemantics;
  }

  @Nullable
  @Override
  public <I> I getItem(@NotNull Class<I> itemClass) {
    return null;
  }

  @Override
  public String toString() {
    return CoreItemTypes.simplifyType(myItemId.toString()) + ':' + mySemantics;
  }

  /**
   * Does not traverse transient row chain - see {@link StructureRows#makeShallow}
   */
  static StructureRow copy(StructureRow row) {
    return row instanceof ShallowRow ? row : new ShallowRow(row.getRowId(), row.getItemId(), row.getSemantics());
  }
}
