package com.almworks.jira.structure.api.rest;

import java.util.Map;

public final class RestTransformSpec {
  public String module;

  public String key;

  public Map<String, Object> params;

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RestTransformSpec that = (RestTransformSpec) o;
    if (module != null ? !module.equals(that.module) : that.module != null) return false;
    if (params != null ? !params.equals(that.params) : that.params != null) return false;
    return true;
  }

  @Override
  public int hashCode() {
    int result = module != null ? module.hashCode() : 0;
    result = 31 * result + (params != null ? params.hashCode() : 0);
    return result;
  }

  @Override
  public String toString() {
    return "RestTransformSpec{" +
      "module='" + module + '\'' +
      ", params='" + params + '\'' +
      '}';
  }
}
