package com.almworks.jira.structure.api.query;

import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.jira.util.MessageSet;

import java.util.List;

/**
 * Utility methods for {@link StructureQueryConstraint} implementations.
 * */
public class StructureQueryConstraints {
  /**
   * Checks that the arguments list contains not less than {@code minArguments} and not more than {@code maxArguments} elements.
   * Intended to be used in {@link StructureQueryConstraint#validate(List)}.
   * @param arguments constraint arguments
   * @param minArguments the minimum number of arguments the constraint can take
   * @param maxArguments the maximum number of arguments the constraint can take
   * @param messageSet the message set where the resulting error message will be added
   * @return the specified message set
   * */
  public static MessageSet validateArgumentCount(List<String> arguments, int minArguments, int maxArguments, 
    MessageSet messageSet) 
  {
    assert minArguments <= maxArguments;
    int nArgs = arguments.size();
    if (nArgs < minArguments) {
      messageSet.addErrorMessage(StructureUtil.getTextInCurrentUserLocale("s.jql.constraints.error.args.min", 
        nArgs, minArguments));
    }
    if (nArgs > maxArguments) {
      messageSet.addErrorMessage(StructureUtil.getTextInCurrentUserLocale("s.jql.constraints.error.args.max",
        nArgs, maxArguments));
    }
    return messageSet;
  }
  
  private StructureQueryConstraints() {}
}
