package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.builder.*;
import com.atlassian.annotations.PublicApi;

@PublicApi
public class SharedAttributeLoaders {
  public static <T> ItemAttributeLoaderBuilder<T, Object> itemLoader(AttributeSpec<T> spec) {
    return new ItemAttributeLoaderBuilder<T, Object>().spec(spec);
  }

  public static <T> DerivedAttributeLoaderBuilder<T> derivedLoader(AttributeSpec<T> spec) {
    return new DerivedAttributeLoaderBuilder<T>().spec(spec);
  }

  public static <T, D> UniDerivedAttributeLoaderBuilder<T, D> derivedLoader(AttributeSpec<T> spec,
    AttributeSpec<D> dependencySpec)
  {
    return new UniDerivedAttributeLoaderBuilder<T, D>()
      .spec(spec)
      .dependency(dependencySpec);
  }

  public static <T, X, Y> BiDerivedAttributeLoaderBuilder<T, X, Y> derivedLoader(AttributeSpec<T> spec,
    AttributeSpec<X> xDependency, AttributeSpec<Y> yDependency)
  {
    return new BiDerivedAttributeLoaderBuilder<T, X, Y>()
      .spec(spec)
      .dependencies(xDependency, yDependency);
  }

  public static <T> DerivedAttributeLoaderBuilder<T> constantLoader(AttributeSpec<T> spec, AttributeValue<T> value) {
    return derivedLoader(spec).valueFunctionAV(() -> value);
  }

  public static <T> SingleRowAttributeLoaderBuilder<T> singleRowLoader(AttributeSpec<T> spec) {
    return new SingleRowAttributeLoaderBuilder<T>().spec(spec);
  }

  SharedAttributeLoaders() {
  }
}
