package com.almworks.jira.structure.api.attribute;

import com.almworks.integers.LongList;
import com.atlassian.annotations.PublicApi;

/**
 * Used to check if the previously loaded values may have changed.
 *
 * @see StructureAttributeService#getAttributeValuesWithUpdateChecker
 */
@PublicApi
public interface AttributeUpdateChecker {
  /**
   * Checks if there may be an update for the given rows. The specified rows must be a subset of previously specified rows when this
   * checker was retrieved.
   *
   * @param rows row IDs to check
   * @return false if the values are guaranteed to be the same; true if they may have changed
   */
  boolean hasUpdate(LongList rows);
}
