package com.almworks.jira.structure.api.util;

import com.almworks.integers.AbstractLongList;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.ToLongFunction;

public class JavaListToLongListAdapter<T> extends AbstractLongList {
  private List<T> mySource;
  private ToLongFunction<T> myF;

  public JavaListToLongListAdapter(List<T> source, ToLongFunction<T> f) {
    mySource = source;
    myF = f;
  }

  @Override
  public int size() {
    return mySource.size();
  }

  @Override
  public long get(int index) throws NoSuchElementException {
    return myF.applyAsLong(mySource.get(index));
  }
}
