package com.almworks.jira.structure.api.sync;

import com.atlassian.annotations.PublicApi;

/**
 * <p>Defines two possible directions for the full synchronization.</p>
 *
 * <p><code>INBOUND</code> direction means the data is taken from issues or external system
 * and applied to structure.</p>
 *
 * <p><code>OUTBOUND</code> direction means the data is taken from structure and applied
 * to issues or to external system.</p>
 *
 * @author Igor Sereda
 */
@PublicApi
public enum SyncDirection {
  /**
   * <p><code>INBOUND</code> direction means the data is taken from issues or external system
   * and applied to structure.</p>
   */
  INBOUND,

  /**
   * <p><code>OUTBOUND</code> direction means the data is taken from structure and applied
   * to issues or to external system.</p>
   */
  OUTBOUND;

  public static final String CODE_OUTBOUND = "OUT";
  public static final String CODE_INBOUND = "IN";
  
  public static String getCode(SyncDirection direction) {
    if (direction == null) return "null";
    switch (direction) {
    case INBOUND: return CODE_INBOUND;
    case OUTBOUND: return CODE_OUTBOUND;
    }
    throw new IllegalArgumentException(direction.toString());
  }

  public static SyncDirection fromCode(String code) {
    if (code == null || "null".equals(code)) return null;
    switch (code) {
    case CODE_INBOUND: return INBOUND;
    case CODE_OUTBOUND: return OUTBOUND;
    }
    throw new IllegalArgumentException(code);
  }
}