package com.almworks.jira.structure.api.process;

public enum ProcessStatus {
  // NB: when adding/changing status values, make corresponding changes to
  // s.process.state.+<NAME> entries in I18N files
  /**
   * The process is scheduled, but haven't run yet
   */
  PENDING(0),
  /**
   * The process is running now
   */
  RUNNING(1),
  /**
   * The process has been finished
   */
  FINISHED(2);

  private final int value;

  ProcessStatus(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static ProcessStatus valueOf(int value) {
    switch (value) {
    case 0: return PENDING;
    case 1: return RUNNING;
    default: return FINISHED;
    }
  }
}
