package com.almworks.jira.structure.api.pinger;

import com.atlassian.annotations.Internal;

@Internal
public interface Pinger {
  int MIN_PING_TIME = 500;
  
  void ping(Pingable subject, long period);
  void stopPinging(Pingable subject);

  /**
   * Implement to be pinged
   */
  interface Pingable {
    /**
     * @return true = continue pinging, false = stop pinging me, exception = stop pinging me (and log exception)
     */
    boolean ping(long now) throws Exception;
  }
}
