package com.almworks.jira.structure.api.perfstats;

import com.atlassian.annotations.Internal;
import com.google.common.collect.Collections2;

import javax.annotation.Nullable;
import java.util.*;

@Internal
public class NodeInfo {
  protected final String myTitle;

  public NodeInfo(String title) {
    myTitle = title;
  }

  public String getTitle() {
    return myTitle;
  }

  public Collection<NodeInfo> getNodes() {
    return Collections.emptyList();
  }

  public boolean isBranch() {
    return false;
  }

  @Override
  public String toString() {
    return myTitle;
  }

  public static class Branch extends NodeInfo {
    private final Collection<NodeInfo> myNodes;

    Branch(String title, Collection<NodeInfo> nodes) {
      super(title);
      myNodes = nodes;
    }

    public Collection<NodeInfo> getNodes() {
      return Collections2.filter(myNodes, Objects::nonNull);
    }

    @Override
    public boolean isBranch() {
      return true;
    }
  }

  @Nullable
  public static Branch branch(String title, Collection<NodeInfo> nodes) {
    return nodes.isEmpty() ? null : new Branch(title, nodes);
  }
  public static Branch branch(String title, NodeInfo... nodes) {
    return branch(title, Arrays.asList(nodes));
  }

  public static NodeInfo leaf(String title) {
    return new NodeInfo(title);
  }
}
