package com.almworks.jira.structure.api.forest.action;

/**
* @author pashky
*/
public class InteractionParameterValue {
  private final Object myValue;
  private final String myIconHtml;
  private final String myExplanation;
  private final boolean myPossible;

  public InteractionParameterValue(Object value, String iconHtml, String explanation, boolean possible) {
    myValue = value;
    myIconHtml = iconHtml;
    myExplanation = explanation;
    myPossible = possible;
  }

  public Object getValue() {
    return myValue;
  }

  public String getIconHtml() {
    return myIconHtml;
  }

  public String getExplanation() {
    return myExplanation;
  }

  public boolean isPossible() {
    return myPossible;
  }

  @Override
  public String toString() {
    return "(" + myValue + ", " + myExplanation + ", " + myPossible + ")";
  }
}
