package com.almworks.jira.structure.api.attribute.loader;


import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.ValueFormat;
import com.almworks.jira.structure.api.settings.AttributeSensitivityMode;
import com.atlassian.annotations.Internal;

import java.lang.annotation.*;

/**
 * The annotation is used to mark a custom value format as non-sensitive in standard mode. It is applied to the Java type that is used in a
 * {@link ValueFormat}. All instances of {@link AttributeSpec} with such format are considered non-sensitive in {@code AttributeSensitivityMode.STANDARD}
 * sensitivity mode.
 *
 * @see AttributeSensitivityMode#STANDARD
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Internal
public @interface NonSensitiveInStandardMode {
}
