package com.almworks.jira.structure.api.rest;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class RestForestSpec {
  public Long structureId;
  public Integer version;
  public RestSQuery sQuery;
  public String type;
  public List<RestTransformSpec> transforms;
  public Boolean title;

  @Override
  public int hashCode() {
    return new HashCodeBuilder()
      .append(this.structureId)
      .append(this.version)
      .append(this.sQuery)
      .append(this.type)
      .append(this.transforms)
      .append(this.title)
      .toHashCode();
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    final RestForestSpec other = (RestForestSpec) obj;
    return new EqualsBuilder()
      .append(this.structureId, other.structureId)
      .append(this.version, other.version)
      .append(this.sQuery, other.sQuery)
      .append(this.type, other.type)
      .append(this.transforms, other.transforms)
      .append(this.title, other.title)
      .isEquals();
  }

  @Override
  public String toString() {
    return "RestForestSpec{" +
      "structureId=" + structureId +
      ", version=" + version +
      ", sQuery=" + sQuery +
      ", type='" + type + '\'' +
      ", transforms=" + transforms +
      ", title=" + title +
      '}';
  }

  public static String toString(RestForestSpec spec) {
    return spec == null ? "null" : spec.toString();
  }
}
