package com.almworks.jira.structure.api.event;

import com.almworks.integers.LongList;
import org.jetbrains.annotations.NotNull;

/**
 * {@code IssueChangeEvent} represents the details of a single issue change.
 *
 * @see IssueListener
 * @see IssueEventBridge
 */
public class JiraChangeEvent {
  @NotNull
  private final JiraChangeType myChangeType;

  public JiraChangeEvent(@NotNull JiraChangeType changeType) {
    if (changeType == null) {
      throw new NullPointerException("changeType cannot be null");
    }
    myChangeType = changeType;
  }

  /**
   * @return the event type
   */
  @NotNull
  public JiraChangeType getChangeType() {
    return myChangeType;
  }

  /**
   * @return sorted list of IDs of the issues affected by this change
   */
  public LongList getAffectedIssuesSorted() {
    return LongList.EMPTY;
  }

  public String toString() {
    return myChangeType.toString();
  }
}
