package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.ScanningAttributeContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.Set;

public class ScanningNumberSumLoader extends AbstractScanningLoader<Number> {
  private final AttributeSpec<Number> myDependency;

  public ScanningNumberSumLoader(@NotNull AttributeSpec<Number> spec, AttributeSpec<Number> dependency) {
    super(spec);
    myDependency = dependency;
  }

  @Nullable
  @Override
  public Set<AttributeSpec<?>> getAttributeDependencies() {
    return Collections.singleton(myDependency);
  }

  @Override
  @Nullable
  protected Number loadValueForPassingRow(@Nullable Number precedingValue, ScanningAttributeContext context) {
    NumberAccumulator acc = new NumberAccumulator();
    acc.add(precedingValue);
    acc.add(context.getDependencyValue(myDependency));
    return acc.toNumber();
  }
}
