package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;

import java.util.*;

public abstract class ItemTypeAttributeLoader<A> extends AbstractItemAttributeLoader<A> {
  protected final Set<String> myItemTypes;

  public ItemTypeAttributeLoader(AttributeSpec<A> spec, String... itemTypes) {
    super(spec);
    if (itemTypes == null || itemTypes.length == 0) {
      throw new IllegalArgumentException("empty or null item types");
    }
    myItemTypes = Collections.unmodifiableSet(new HashSet<>(Arrays.asList(itemTypes)));
  }

  public final boolean isItemTypeSupported(String itemType) {
    return myItemTypes.contains(itemType);
  }
}
