/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.integers.IntIterator;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongList;
import com.almworks.integers.LongOpenHashSet;
import com.almworks.integers.LongSet;
import com.almworks.jira.structure.api.attribute.CoreAttributeSpecs;
import com.almworks.jira.structure.api.attribute.StructureAttributeService;
import com.almworks.jira.structure.api.attribute.VersionedRowValues;
import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.forest.item.ImmutableItemForest;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.forest.item.ItemForestBuilderImpl;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.permissions.PermissionLevel;
import com.almworks.jira.structure.api.permissions.PermissionRule;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.structure.Structure;
import com.almworks.jira.structure.api.structure.StructureManager;
import com.almworks.jira.structure.api.util.CallableE;
import com.almworks.jira.structure.api.util.ItemDisplayable;
import com.almworks.jira.structure.api.util.JiraComponents;
import com.almworks.jira.structure.api.util.JiraFunc;
import com.almworks.jira.structure.api.util.La;
import com.almworks.jira.structure.api.util.SimpleCallable;
import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.TypeReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureUtil {
    private static final Logger logger = LoggerFactory.getLogger(StructureUtil.class);
    public static final int MAX_PROPERTY_LENGTH = 250;
    public static final La<String, Long> STRING_LONG = new La<String, Long>(){

        @Override
        public Long la(String argument) {
            try {
                return argument == null ? null : Long.valueOf(Long.parseLong(argument.trim()));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    };
    public static final La<IntIterator, Integer> INT_ITERATOR_TO_INT = new La<IntIterator, Integer>(){

        @Override
        public Integer la(IntIterator intIterator) {
            return intIterator.value();
        }
    };
    public static final La<LongIterator, Long> LONG_ITERATOR_TO_LONG = new La<LongIterator, Long>(){

        @Override
        public Long la(LongIterator longIterator) {
            return longIterator.value();
        }
    };
    public static final TypeReference<Map<String, Object>> JSON_MAP = new TypeReference<Map<String, Object>>(){};

    public static PermissionLevel applyPermissions(List<PermissionRule> permissions, ApplicationUser user, List<Object> stack, La<Long, List<PermissionRule>> resolver, PermissionLevel pass) {
        PermissionLevel r = pass;
        if (permissions != null) {
            for (PermissionRule permission : permissions) {
                r = permission.apply(user, r, stack, resolver);
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext createJAXBContext(Class contextClass) {
        Thread thread = Thread.currentThread();
        ClassLoader contextLoader = thread.getContextClassLoader();
        ClassLoader[] loaders = new ClassLoader[]{ClassLoader.getSystemClassLoader(), contextLoader, JAXBContext.class.getClassLoader(), contextClass.getClassLoader()};
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{contextClass});
        }
        catch (JAXBException e) {
            for (int i = 1; i < loaders.length; ++i) {
                try {
                    thread.setContextClassLoader(loaders[i]);
                    context = JAXBContext.newInstance((Class[])new Class[]{contextClass});
                    if (context == null) continue;
                    break;
                }
                catch (JAXBException jAXBException) {
                    // empty catch block
                }
            }
            if (context == null) {
                logger.error("cannot initialize JAXB context for " + contextClass + " (tried loaders: " + Arrays.asList(loaders) + ")", (Throwable)e);
            }
        }
        finally {
            thread.setContextClassLoader(contextLoader);
        }
        return context;
    }

    @Nullable
    public static Long getSingleParameterLong(@Nullable Map map, @Nullable String name) {
        if (map == null || name == null) {
            return null;
        }
        Object r = map.get(name);
        if (r instanceof Long || r instanceof Integer) {
            return ((Number)r).longValue();
        }
        String value = StructureUtil.getSingleString(r);
        if (value != null && value.length() > 0) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                logger.warn("bad parameter " + name + " [" + value + "]");
            }
        }
        return null;
    }

    @Nullable
    public static Integer getSingleParameterInteger(@Nullable Map map, @Nullable String name) {
        if (map == null || name == null) {
            return null;
        }
        Object r = map.get(name);
        if (r instanceof Integer) {
            return (Integer)r;
        }
        String value = StructureUtil.getSingleString(r);
        if (value != null && value.length() > 0) {
            value = value.trim();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                logger.warn("bad parameter " + name + " [" + value + "]");
            }
        }
        return null;
    }

    public static boolean getSingleParameterBoolean(@Nullable Map map, @Nullable String name) {
        if (map == null || name == null) {
            return false;
        }
        Object r = map.get(name);
        if (r instanceof Boolean) {
            return (Boolean)r;
        }
        String value = StructureUtil.getSingleString(r);
        return value != null && "true".equalsIgnoreCase(value.trim());
    }

    @Nullable
    public static String getSingleParameter(@Nullable Map map, @Nullable String name) {
        if (map == null || name == null) {
            return null;
        }
        return StructureUtil.getSingleString(map.get(name));
    }

    @Nullable
    private static String getSingleString(Object r) {
        if (r instanceof Collection) {
            Collection c = (Collection)r;
            r = c.isEmpty() ? null : c.iterator().next();
        } else if (r instanceof String[]) {
            r = ((String[])r).length == 0 ? null : ((String[])r)[0];
        }
        return r == null ? null : String.valueOf(r);
    }

    @NotNull
    public static List<String> getMultiParameter(@Nullable Map map, @Nullable String name) {
        if (map == null || name == null) {
            return Collections.emptyList();
        }
        Object r = map.get(name);
        if (r instanceof Collection) {
            Collection c = (Collection)r;
            ArrayList<String> result = new ArrayList<String>(c.size());
            for (Object o : c) {
                if (o == null) continue;
                result.add(String.valueOf(o));
            }
            return result;
        }
        if (r instanceof String[]) {
            String[] array = (String[])r;
            return array.length == 0 ? Collections.emptyList() : Arrays.asList(array);
        }
        return r == null ? Collections.emptyList() : Collections.singletonList(String.valueOf(r));
    }

    @NotNull
    public static List<Long> getMultiParameterLong(@Nullable Map map, @Nullable String name) {
        return STRING_LONG.arrayList((Collection<String>)StructureUtil.getMultiParameter(map, name));
    }

    public static void setLongProperty(ApplicationProperties properties, String name, String value) {
        String n;
        String s;
        if (value == null) {
            value = "";
        }
        int len = value.length();
        int chunk = Math.min(len, 250);
        properties.setString(name, value.substring(0, chunk));
        value = value.substring(chunk);
        len -= chunk;
        int step = 1;
        while (len > 0) {
            chunk = Math.min(len, 250);
            properties.setString(name + "." + step++, value.substring(0, chunk));
            value = value.substring(chunk);
            len -= chunk;
        }
        while ((s = properties.getDefaultBackedString(n = name + "." + step++)) != null && s.length() > 0) {
            properties.setString(n, null);
        }
    }

    @NotNull
    public static String getLongProperty(ApplicationProperties properties, String name) {
        StringBuilder r = new StringBuilder();
        String s = properties.getDefaultBackedString(name);
        int step = 1;
        while (s != null && s.length() > 0) {
            r.append(s);
            s = properties.getDefaultBackedString(name + "." + step++);
        }
        return r.toString();
    }

    public static boolean getBooleanSystemProperty(String key, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String propertyValue = System.getProperty(key);
            if (propertyValue != null) {
                result = Boolean.parseBoolean(propertyValue);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return result;
    }

    public static long lastOrZero(LongList list) {
        return list == null || list.isEmpty() ? 0L : list.get(list.size() - 1);
    }

    public static boolean listsEqual(LongList list1, LongList list2) {
        boolean empty2;
        boolean empty1 = list1 == null || list1.isEmpty();
        boolean bl = empty2 = list2 == null || list2.isEmpty();
        if (empty1 && empty2) {
            return true;
        }
        if (empty1 || empty2) {
            return false;
        }
        return list1.equals(list2);
    }

    @Nullable
    public static List<PermissionRule> copyPermissionsOrNull(@Nullable Collection<? extends PermissionRule> permissions) {
        return permissions == null ? null : StructureUtil.copyPermissions(permissions);
    }

    @NotNull
    public static List<PermissionRule> copyPermissions(@Nullable Collection<? extends PermissionRule> permissions) {
        ArrayList<PermissionRule> r = new ArrayList<PermissionRule>(permissions == null ? 0 : permissions.size());
        if (permissions != null) {
            for (PermissionRule permissionRule : permissions) {
                r.add(permissionRule.clone());
            }
        }
        return r;
    }

    @NotNull
    public static String getDebugIssueString(@Nullable Long issue) {
        return issue == null ? "null" : StructureUtil.appendDebugIssueString(issue, new StringBuilder()).toString();
    }

    public static StringBuilder appendDebugIssueString(@Nullable Long issue, StringBuilder sb) {
        if (issue == null) {
            sb.append("null");
        } else {
            StructureUtil.appendDebugIssueString(issue, StructureUtil.getDebugIssueKey(issue), sb);
        }
        return sb;
    }

    @Nullable
    public static String getDebugIssueKey(long issueId) {
        try {
            IssueManager issueManager = JiraComponents.getIssueManager();
            MutableIssue io = issueManager == null ? null : issueManager.getIssueObject(Long.valueOf(issueId));
            return io == null ? null : io.getKey();
        }
        catch (Exception | LinkageError throwable) {
            return null;
        }
    }

    @NotNull
    public static String getDebugIssueString(@Nullable Issue issue) {
        return issue == null ? "null" : StructureUtil.appendDebugIssueString(issue.getId(), issue.getKey(), new StringBuilder()).toString();
    }

    public static String issueKeyOrId(@Nullable Issue issue, @Nullable Long issueId) {
        return issue != null ? issue.getKey() : (issueId != null ? "issue #" + issueId : "(no issue ID)");
    }

    @NotNull
    public static StringBuilder appendDebugIssueString(@Nullable Long issueId, @Nullable String issueKey, StringBuilder r) {
        if (issueKey != null) {
            r.append('(').append(issueKey).append(' ').append(issueId).append(')');
        } else {
            r.append(issueId);
        }
        return r;
    }

    @NotNull
    public static StringBuilder appendDebugStructureString(final long structureId, final StructureManager manager, final StringBuilder sb) {
        return StructureAuth.sudo(new SimpleCallable<StringBuilder>(){

            @Override
            public StringBuilder call() {
                try {
                    Structure structure = manager.getStructure(structureId, PermissionLevel.NONE);
                    String name = structure.getName();
                    return sb.append('\'').append(name).append("' (#").append(structureId).append(')');
                }
                catch (StructureException ignored) {
                    return sb.append("#").append(structureId);
                }
            }
        });
    }

    public static String getDebugStructureString(long structureId, StructureManager structureManager) {
        return StructureUtil.appendDebugStructureString(structureId, structureManager, new StringBuilder()).toString();
    }

    @NotNull
    public static String username(@Nullable ApplicationUser user) {
        String username = user != null ? user.getName() : "anonymous";
        return username == null ? "user[name = null]" : username;
    }

    public static String debugConstant(IssueConstant constant) {
        return constant == null ? "<null>" : constant.getName() + "(" + constant.getId() + ")";
    }

    public static String debugAction(ActionDescriptor action) {
        return action == null ? "<null>" : action.getName() + "(" + action.getId() + ")";
    }

    public static String getTextInCurrentUserLocale(String key, Object ... parameters) {
        return StructureUtil.getText(null, StructureAuth.getUser(), key, parameters);
    }

    @NotNull
    public static String getText(final @Nullable Locale locale, final @Nullable ApplicationUser user, final String textKey, final Object ... messageParameters) {
        final I18nHelper.BeanFactory factory = ComponentAccessor.getI18nHelperFactory();
        if (factory == null) {
            return textKey + ' ' + Arrays.toString(messageParameters);
        }
        return JiraComponents.withThreadContextClassLoaderOf(factory, new CallableE<String, RuntimeException>(){

            @Override
            public String call() {
                I18nHelper i18nHelper = locale != null || user == null ? factory.getInstance(locale != null ? locale : StructureUtil.getJiraDefaultLocale()) : factory.getInstance(user);
                return i18nHelper.getText(textKey, (Object)messageParameters);
            }
        });
    }

    @NotNull
    public static Locale getJiraDefaultLocale() {
        ApplicationProperties appProps = JiraComponents.getApplicationProperties();
        if (appProps == null) {
            logger.warn("No application properties: probably a System 2 plugin now? Using root (neutral) locale.");
            return Locale.ROOT;
        }
        Locale defaultLocale = appProps.getDefaultLocale();
        if (defaultLocale == null) {
            logger.warn("No JIRA default locale. Using root (neutral) locale.");
            return Locale.ROOT;
        }
        return defaultLocale;
    }

    public static String getUserKey(@Nullable ApplicationUser user) {
        return user == null ? null : user.getKey();
    }

    @Nullable
    public static String getUserName(@Nullable ApplicationUser user) {
        return user == null ? null : user.getUsername();
    }

    @Nullable
    public static ApplicationUser getUserByKey(@Nullable String userKey) {
        return JiraFunc.USERKEY_APPLICATIONUSER.la(userKey);
    }

    @Nullable
    public static ApplicationUser getApplicationUserByName(@Nullable String userName) {
        return JiraComponents.getUserManager().getUserByName(userName);
    }

    @Nullable
    public static String getUserNameByKey(@Nullable String userKey) {
        ApplicationUser user = StructureUtil.getUserByKey(userKey);
        return user == null ? null : user.getName();
    }

    @Nullable
    public static String migrateUserNameToUserKey(@Nullable String userName) {
        return userName == null ? null : IdentifierUtils.toLowerCase((String)userName);
    }

    public static int createRuntimeSignature() {
        long v = System.currentTimeMillis() + 1299827L * System.nanoTime() + (long)(31 * new Object().hashCode());
        return new Long(v).hashCode();
    }

    public static String getDebugRowString(long row) {
        return "(row " + row + ")";
    }

    public static String getDebugRowString(StructureRow row) {
        return row == null ? "" : row.toString();
    }

    @NotNull
    public static String toJson(@Nullable Object object) {
        return StructureUtil.toJson(object, StructureUtil.defaultMapper());
    }

    @NotNull
    public static String toJson(@Nullable Object object, ObjectMapper mapper) {
        if (object == null) {
            return "";
        }
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.warn("failed to serialize " + object, (Throwable)e);
            return "";
        }
    }

    @Nullable
    public static <T> T fromJson(String specJson, Class<T> expectedClass) {
        return StructureUtil.fromJson(specJson, expectedClass, StructureUtil.defaultMapper());
    }

    @Nullable
    public static <T> T fromJson(String specJson, Class<T> expectedClass, ObjectMapper mapper) {
        if (specJson == null || specJson.length() == 0) {
            return null;
        }
        try {
            return (T)mapper.readValue(specJson, expectedClass);
        }
        catch (IOException e) {
            logger.warn("failed to deserialize " + specJson + " for " + expectedClass, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static <T> T fromJson(String json, TypeReference<T> typeRef) {
        return StructureUtil.fromJson(json, typeRef, StructureUtil.defaultMapper());
    }

    @Nullable
    public static <T> T fromJson(String json, TypeReference<T> typeRef, ObjectMapper mapper) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, typeRef);
        }
        catch (IOException e) {
            logger.warn("failed to deserialize " + json + " for " + typeRef, (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> fromJson(String json) {
        return StructureUtil.fromJson(json, StructureUtil.defaultMapper());
    }

    @Nullable
    public static Map<String, Object> fromJson(String json, ObjectMapper mapper) {
        return StructureUtil.fromJson(json, JSON_MAP, mapper);
    }

    @Nullable
    public static <T> T fromMap(Map json, Class<T> expectedClass) {
        return StructureUtil.fromMap(json, expectedClass, StructureUtil.defaultMapper());
    }

    @Nullable
    public static <T> T fromMap(Map json, Class<T> expectedClass, ObjectMapper mapper) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            return (T)mapper.convertValue((Object)json, expectedClass);
        }
        catch (IllegalArgumentException e) {
            logger.warn("failed to convert " + json + " to " + expectedClass, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Map<String, Object> toMap(Object object) {
        return StructureUtil.toMap(object, StructureUtil.defaultMapper());
    }

    @Nullable
    public static Map<String, Object> toMap(Object object, ObjectMapper mapper) {
        try {
            return (Map)mapper.convertValue(object, JSON_MAP);
        }
        catch (IllegalArgumentException e) {
            logger.warn("failed to convert " + object + " to " + JSON_MAP, (Throwable)e);
            return null;
        }
    }

    public static ObjectMapper defaultMapper() {
        return new ObjectMapper().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    public static ObjectMapper withUnknownPropertiesMapper() {
        return StructureUtil.defaultMapper().disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    public static <T> Class<Set<T>> setType() {
        return Set.class;
    }

    public static <T, V> Class<Map<T, V>> mapType() {
        return Map.class;
    }

    public static <T> Class<List<T>> listType() {
        return List.class;
    }

    public static boolean onlyOneIsTrue(boolean ... booleans) {
        boolean result = false;
        for (boolean b : booleans) {
            if (!b) continue;
            if (result) {
                result = false;
                break;
            }
            result = true;
        }
        return result;
    }

    public static <T> void swap(List<T> list, int a, int b) {
        T tmp = list.get(a);
        list.set(a, list.get(b));
        list.set(b, tmp);
    }

    public static void warnExceptionIfDebug(Logger log, String message, Throwable t) {
        if (log.isDebugEnabled()) {
            log.warn(message, t);
        } else if (t != null) {
            log.warn(message + " " + StructureUtil.getMessageWithCauseChain(t));
        } else {
            log.warn(message);
        }
    }

    public static String getMessageWithCauseChain(Throwable t) {
        StringBuilder sb = new StringBuilder();
        String pre = "";
        while (t != null) {
            sb.append(pre).append(t);
            t = t.getCause();
            pre = "; ";
        }
        return sb.toString();
    }

    public static String getItemDescription(ItemIdentity itemId) {
        try {
            ItemDisplayable displayable;
            StructureAttributeService attributeService = JiraComponents.getOSGiComponentInstanceOfType(StructureAttributeService.class);
            if (attributeService != null && (displayable = StructureUtil.getItemDisplayable(itemId, attributeService)) != null) {
                return displayable.getDescription();
            }
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
        return null;
    }

    public static ItemDisplayable getItemDisplayable(ItemIdentity itemId, StructureAttributeService attributeService) {
        return StructureUtil.getItemDisplayable(new ItemForestBuilderImpl().nextRow(itemId).build(), attributeService);
    }

    public static ItemDisplayable getItemDisplayable(StructureRow row, StructureAttributeService attributeService) {
        return StructureUtil.getItemDisplayable(ImmutableItemForest.of(row), attributeService);
    }

    public static ItemDisplayable getItemDisplayable(ItemForest fragment, StructureAttributeService attributeService) {
        long rowId;
        assert (fragment.getForest().size() == 1) : fragment;
        VersionedRowValues values = attributeService.getAttributeValues(fragment, fragment.getForest().getRows(), Arrays.asList(CoreAttributeSpecs.DISPLAYABLE_TEXT, CoreAttributeSpecs.URL));
        String description = values.get(rowId = fragment.getForest().getRow(0), CoreAttributeSpecs.DISPLAYABLE_TEXT);
        if (StringUtils.isEmpty((String)description)) {
            description = fragment.getRow(rowId).getItemId().toString();
        }
        String url = values.get(rowId, CoreAttributeSpecs.URL);
        return new ItemDisplayable(description, url);
    }

    @Nullable
    public static String getGroupName(Group group) {
        return group == null ? null : group.getName();
    }

    public static boolean isMutuallyExclusive(LongList set1, LongList set2) {
        if (set2.isEmpty() || set1.isEmpty()) {
            return true;
        }
        boolean insertedIsHashed = set1.size() < set2.size();
        LongList hashed = insertedIsHashed ? set1 : set2;
        LongList iterated = insertedIsHashed ? set2 : set1;
        LongOpenHashSet set = LongOpenHashSet.createFrom((LongIterable)hashed);
        return !set.containsAny((LongIterable)iterated);
    }

    public static boolean isMutuallyExclusive(LongSet set1, LongSet set2) {
        boolean set1Iterated = set1.size() < set2.size();
        LongSet iterated = set1Iterated ? set1 : set2;
        LongSet checked = set1Iterated ? set2 : set1;
        return !checked.containsAny((LongIterable)iterated);
    }

    @NotNull
    public static String toDebugJson(@Nullable Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException | OutOfMemoryError e) {
            return "?" + e + "?";
        }
    }

    public static long nn(@Nullable Long value, long defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static int nn(@Nullable Integer value, int defaultValue) {
        return value == null ? defaultValue : value;
    }

    @NotNull
    public static <T> T nnv(@Nullable T value, @NotNull T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static long lv(String v, long defaultValue) {
        if (v == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int iv(String v, int defaultValue) {
        if (v == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Long lvn(String v) {
        if (v == null) {
            return null;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String nn(String value) {
        return value == null ? "" : value;
    }

    public static long nnl(Long value) {
        return value == null ? 0L : value;
    }

    public static int nni(Integer value) {
        return value == null ? 0 : value;
    }

    @NotNull
    public static String getBaseUrl() {
        com.atlassian.sal.api.ApplicationProperties ap = JiraComponents.getOSGiComponentInstanceOfType(com.atlassian.sal.api.ApplicationProperties.class);
        if (ap != null) {
            return StructureUtil.nn(ap.getBaseUrl());
        }
        logger.warn("sal ApplicationProperties is null");
        return "";
    }

    public static String decodeURL(String url) {
        try {
            return url == null ? "" : URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("NO UTF-8?", (Throwable)e);
            return url;
        }
        catch (IllegalArgumentException e) {
            logger.error("when decoding [" + url + "]", (Throwable)e);
            return url;
        }
    }

    public static String encodeURL(String url) {
        try {
            return url == null ? "" : URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("NO UTF-8?", (Throwable)e);
            return url;
        }
        catch (IllegalArgumentException e) {
            logger.error("when encoding [" + url + "]", (Throwable)e);
            return url;
        }
    }

    public static String encodeURIComponent(String cmp) {
        return StructureUtil.encodeURL(cmp).replaceAll("\\+", "%20").replaceAll("%21", "!").replaceAll("%27", "'").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%7E", "~");
    }

    public static boolean isSubMap(Map<String, Object> map, Map<String, Object> subMap) {
        return map.entrySet().containsAll(subMap.entrySet());
    }

    @Internal
    public static boolean isDevMode() {
        return "true".equals(System.getProperty("jira.dev.mode")) || "true".equals(System.getProperty("atlassian.dev.mode"));
    }

    @NotNull
    public static String nonBlank(@Nullable String value) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException("argument cannot be null or blank");
        }
        return value.trim();
    }
}

