/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.ValueFormat;
import com.almworks.jira.structure.api.util.MapObject;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecParams
extends MapObject {
    private static final Logger logger = LoggerFactory.getLogger(SpecParams.class);

    public SpecParams(Map<String, Object> map) {
        super(map);
    }

    @Override
    @Nullable
    public SpecParams getObject(String name) {
        Object value = this.myObject.opt(name);
        if (!(value instanceof Map)) {
            return null;
        }
        return new SpecParams((Map)value);
    }

    @Nullable
    public <T> AttributeSpec<T> getAttributeParameter(ValueFormat<T> expectedFormat) {
        return this.getAttributeParameter("attribute", expectedFormat);
    }

    @Nullable
    public <T> AttributeSpec<T> getAttributeParameter(String name, ValueFormat<T> expectedFormat) {
        ValueFormat<?> standardFormat;
        SpecParams attributeObject = this.getObject(name);
        if (attributeObject == null) {
            return null;
        }
        String format = attributeObject.getString("format");
        if (format != null && expectedFormat != null && !expectedFormat.getFormatId().equals(format) && !ValueFormat.ANY.getFormatId().equals(format)) {
            return null;
        }
        if (expectedFormat == null && (standardFormat = ValueFormat.getStandardFormat(format)) != null) {
            expectedFormat = standardFormat;
        }
        return this.buildAttributeFromParamsMap(attributeObject, expectedFormat);
    }

    @Nullable
    private <T> AttributeSpec<T> buildAttributeFromParamsMap(@NotNull SpecParams attributeObject, ValueFormat<T> expectedFormat) {
        if (expectedFormat == null) {
            return null;
        }
        String id = attributeObject.getString("id");
        Object params = attributeObject.get("params");
        Map paramsMap = params instanceof Map ? (Map)params : null;
        try {
            return new AttributeSpec<T>(id, expectedFormat, paramsMap);
        }
        catch (IllegalArgumentException e) {
            logger.debug("invalid params - cannot extract AttributeSpec: " + attributeObject);
            return null;
        }
    }
}

