/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.sync.util;

import com.almworks.integers.IntIterable;
import com.almworks.integers.IntIterator;
import com.almworks.integers.IntMinusIterator;
import com.almworks.integers.LongArray;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongList;
import com.almworks.integers.LongLongMap;
import com.almworks.integers.WritableLongLongMap;
import com.almworks.jira.structure.api.StructurePluginHelper;
import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.error.StructureError;
import com.almworks.jira.structure.api.error.StructureErrorCategory;
import com.almworks.jira.structure.api.error.StructureErrors;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.forest.ForestSource;
import com.almworks.jira.structure.api.forest.action.ActionParameters;
import com.almworks.jira.structure.api.forest.action.ActionResult;
import com.almworks.jira.structure.api.forest.action.ForestAction;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.forest.item.ItemForestBuffer;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.item.CoreIdentities;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.RowManager;
import com.almworks.jira.structure.api.sync.util.HierarchyHelper;
import com.almworks.jira.structure.api.sync.util.SyncChangeListener;
import com.almworks.jira.structure.api.sync.util.SyncLogger;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.parser.JqlParseErrorMessage;
import com.atlassian.jira.jql.parser.JqlParseErrorMessages;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncUtil {
    public static final SyncChangeListener DUMMY_LISTENER = new SyncChangeListener(){

        @Override
        public void onInsert(long parentRow, LongIterable addedIssues) {
        }

        @Override
        public void onMove(long parentRow, long issueId) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean merge(ForestSource ufs, RowManager rowManager, long row, long targetRow, boolean followSymlinks, boolean removeRow, @Nullable WritableLongLongMap mergedRows) throws StructureException {
        int targetRowIdx;
        if (row == targetRow) {
            throw StructureErrors.INVALID_FOREST_OPERATION.forRow(row).withMessage("cannot merge row " + row + " into itself");
        }
        Forest forest = ufs.getLatest().getForest();
        int rowIdx = forest.indexOf(row);
        int n = targetRowIdx = targetRow == 0L ? -1 : forest.indexOf(targetRow);
        if (rowIdx < 0 || targetRow != 0L && targetRowIdx < 0) {
            SyncLogger slog = SyncLogger.get();
            if (slog.getLogger().isDebugEnabled()) {
                slog.debug("skipping merge of", slog.row(row), "into", slog.row(targetRow), ": one of them is not in the current forest");
            }
            return false;
        }
        if (targetRowIdx >= 0 && SyncUtil.subtreeContains(forest, rowIdx, targetRowIdx)) {
            SyncLogger slog = SyncLogger.get();
            if (slog.isInfoEnabled()) {
                slog.info("skipping merge of", slog.row(row), "into", slog.row(targetRow), ": target row", targetRow, "is in the subtree of donor row", row);
            }
            return false;
        }
        SyncLogger slogDebug = null;
        if (SyncLogger.isDebug()) {
            slogDebug = SyncLogger.get();
            slogDebug.debug("_merge_", slogDebug.row(row), "into", slogDebug.row(targetRow));
            slogDebug.pushPrefix("merge");
        }
        try {
            SyncUtil.merge0(ufs, forest, rowManager, row, rowIdx, targetRowIdx, rowIdx, followSymlinks, removeRow, mergedRows, new boolean[]{true});
        }
        finally {
            if (slogDebug != null) {
                slogDebug.popPrefix();
            }
        }
        return true;
    }

    public static boolean merge(ForestSource ufs, RowManager rowManager, long row, long targetRow) throws StructureException {
        return SyncUtil.merge(ufs, rowManager, row, targetRow, false, true, null);
    }

    public static boolean merge(ForestSource ufs, RowManager rowManager, long row, long targetRow, boolean followSymlinks) throws StructureException {
        return SyncUtil.merge(ufs, rowManager, row, targetRow, followSymlinks, true, null);
    }

    private static boolean subtreeContains(Forest forest, int idx, int checkIdx) {
        int size = forest.size();
        int startDepth = forest.getDepth(idx++);
        while (idx < size && forest.getDepth(idx) > startDepth) {
            if (idx == checkIdx) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private static void merge0(ForestSource ufs, Forest forest, RowManager rowManager, long row, int rowIdx, int targetRowIdx, int origDonorIdx, boolean followSymlinks, boolean removeRow, WritableLongLongMap mergedRows, boolean[] subtreeMergeSuccess) throws StructureException {
        long targetRow = targetRowIdx < 0 ? 0L : forest.getRow(targetRowIdx);
        IntIterator allTargetChildrenIdxIt = forest.getChildrenIndicesIterator(targetRowIdx);
        IntIterator targetChildrenIdxIt = allTargetChildrenIdxIt;
        if (targetChildrenIdxIt.hasNext()) {
            targetChildrenIdxIt = new IntMinusIterator((IntIterable)allTargetChildrenIdxIt, (IntIterable)new IntIterator.Single(origDonorIdx));
        }
        Map<ItemIdentity, Integer> targetChildrenItemIdIndex = SyncUtil.buildItemIdIndex(forest, rowManager, followSymlinks, targetChildrenIdxIt);
        long after = allTargetChildrenIdxIt.hasValue() ? forest.getRow(allTargetChildrenIdxIt.value()) : 0L;
        LongArray childrenToMove = new LongArray();
        for (IntIterator cii : forest.getChildrenIndicesIterator(rowIdx)) {
            int childRowIdx = cii.value();
            long childRow = forest.getRow(childRowIdx);
            ItemIdentity childItemId = SyncUtil.getItemId(rowManager, childRow, followSymlinks);
            Integer targetChildIdx = targetChildrenItemIdIndex.get(childItemId);
            if (targetChildIdx != null) {
                if (!childrenToMove.isEmpty()) {
                    after = SyncUtil.move(ufs, (LongList)childrenToMove, targetRow, after, subtreeMergeSuccess);
                    childrenToMove.clear();
                }
                SyncUtil.merge0(ufs, forest, rowManager, childRow, childRowIdx, targetChildIdx, origDonorIdx, followSymlinks, true, mergedRows, subtreeMergeSuccess);
                continue;
            }
            childrenToMove.add(childRow);
        }
        if (!childrenToMove.isEmpty()) {
            after = SyncUtil.move(ufs, (LongList)childrenToMove, targetRow, after, subtreeMergeSuccess);
        }
        if (removeRow && subtreeMergeSuccess[0]) {
            SyncUtil.remove(ufs, (LongList)new LongList.Single(row));
            if (mergedRows != null) {
                mergedRows.put(row, targetRow);
            }
        }
    }

    public static long move(ForestSource ufs, LongList rows, long under, long after, boolean[] success) throws StructureException {
        return SyncUtil.move(ufs, rows, under, after, false, success);
    }

    public static long move(ForestSource ufs, @Nullable LongList rows, long under, long after, boolean invalidMoveExpected, boolean[] success) throws StructureException {
        if (rows == null || rows.isEmpty()) {
            return after;
        }
        ForestAction.Move move = new ForestAction.Move(rows, under, after, 0L);
        try {
            ufs.apply(move, ActionParameters.IGNORE_MOVED_ROW_MISSING_MAP);
            if (SyncLogger.isDebug()) {
                SyncLogger slog = SyncLogger.get();
                slog.debug("_move_", slog.rows((LongIterable)rows), "under:", slog.row(under), "after:", slog.row(after));
            }
            return rows.get(rows.size() - 1);
        }
        catch (StructureException e) {
            SyncUtil.processMoveError(e, under, rows, after, invalidMoveExpected);
            if (success != null) {
                success[0] = false;
            }
            return after;
        }
    }

    private static void processMoveError(StructureException exception, long targetRow, LongList rows, long after, boolean invalidMoveExpected) throws StructureException {
        SyncLogger slog = SyncLogger.get();
        StringBuilder errorMessage = new StringBuilder("could not move ");
        slog.appendRows((LongIterable)rows, errorMessage).append(" under ").append(slog.row(targetRow)).append(" after ").append(slog.row(after)).append(": ");
        if (invalidMoveExpected && exception.getError().equals(StructureErrors.INVALID_FOREST_OPERATION) && slog.getLogger().isInfoEnabled()) {
            slog.info(errorMessage.append(exception.getProblemDetails()).append(". ").append("Most likely, it is caused by previous changes made by this synchronizer; in that case, it is not a problem. ").append("Another possible but unlikely reason: concurrent changes made by users. If it can be the case, please run a resync."));
        } else {
            SyncUtil.appendStructureException(exception, errorMessage);
            slog.warn(errorMessage.toString());
        }
    }

    public static void remove(ForestSource ufs, @Nullable LongList rows) throws StructureException {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        ForestAction.Remove remove = new ForestAction.Remove(rows);
        try {
            ufs.apply(remove, ActionParameters.IGNORE_REMOVED_ROW_MISSING_MAP);
            if (SyncLogger.isDebug()) {
                SyncLogger.get().debug("_remove_", SyncLogger.get().rows((LongIterable)rows));
            }
        }
        catch (StructureException e) {
            SyncLogger slog = SyncLogger.get();
            StringBuilder errorMessage = new StringBuilder("could not remove ");
            slog.appendRows((LongIterable)rows, errorMessage).append(": ");
            SyncUtil.processUpdateError(e, slog, errorMessage);
        }
    }

    @Nullable
    public static LongLongMap add(ForestSource ufs, ItemForest fragment, long under, long after) throws StructureException {
        ForestAction.Add add = new ForestAction.Add(fragment, under, after, 0L);
        return SyncUtil.add(ufs, add);
    }

    @Nullable
    public static LongLongMap add(ForestSource ufs, ForestAction.Add add) throws StructureException {
        try {
            ActionResult actionResult = ufs.apply(add, ActionParameters.IGNORE_ADD_AFTER_ROW_PROBLEMS_MAP);
            LongLongMap rowIdReplacements = actionResult.getRowIdReplacements();
            if (SyncLogger.isDebug()) {
                SyncLogger slog = SyncLogger.get();
                slog.debug("_add_", slog.itemForest(add.getFragment()), "under:", slog.row(add.getUnder()), "after:", slog.row(add.getAfter()), "before:", slog.row(add.getBefore()), "replacements:", rowIdReplacements);
            }
            return rowIdReplacements;
        }
        catch (StructureException e) {
            boolean before = add.getBefore() != 0L;
            SyncLogger slog = SyncLogger.get();
            StringBuilder errorMessage = new StringBuilder("could not add ");
            slog.appendItemForest(add.getFragment(), errorMessage).append(" under ").append(slog.row(add.getUnder())).append(before ? " before " : " after ").append(slog.row(before ? add.getBefore() : add.getAfter())).append(": ");
            SyncUtil.processUpdateError(e, slog, errorMessage);
            return null;
        }
    }

    public static void insert(ForestSource ufs, ItemForestBuffer addedForest, LongList issues, long under, long after) throws StructureException {
        addedForest.clear();
        for (LongIterator it : issues) {
            addedForest.add(CoreIdentities.issue(it.value()));
        }
        SyncUtil.add(ufs, addedForest, under, after);
    }

    public static void processUpdateError(StructureException exception, SyncLogger slog, StringBuilder errorMessage) throws StructureException {
        SyncUtil.appendStructureException(exception, errorMessage);
        slog.warn(errorMessage.toString());
    }

    private static StringBuilder appendStructureException(StructureException se, StringBuilder errorMessage) throws StructureException {
        StructureError error = se.getError();
        if (error.is(StructureErrorCategory.NOT_FOUND)) {
            errorMessage.append("could not access item ").append(se.getItem());
            return errorMessage;
        }
        if (error == StructureErrors.INVALID_FOREST_OPERATION) {
            errorMessage.append(se.getProblemDetails()).append(se.getProblemDetails().endsWith(".") ? " " : ". ").append("This might be a temporary problem caused by concurrent changes to this structure. ").append("To remedy the situation, try running resync. If the problem persists, please contact support@almworks.com.");
        } else if (error.getCode() == 6014) {
            errorMessage.append(se.getProblemDetails()).append(". ").append(" To remedy the situation, try running resync. If the problem persists, please contact support@almworks.com.");
        } else if (error.isOneOf(StructureErrors.UNAVAILABLE_MODULE, StructureErrors.FOREST_CHANGE_PROHIBITED_BY_PARENT_PERMISSIONS)) {
            errorMessage.append(se.getProblemDetails());
        } else {
            throw se;
        }
        return errorMessage;
    }

    private static Map<ItemIdentity, Integer> buildItemIdIndex(Forest forest, RowManager rowManager, boolean followSymlinks, IntIterator idxs) {
        if (!idxs.hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<ItemIdentity, Integer> firstRowIdxs = new HashMap<ItemIdentity, Integer>();
        for (IntIterator i : idxs) {
            ItemIdentity itemId = SyncUtil.getItemId(rowManager, forest.getRow(i.value()), followSymlinks);
            if (firstRowIdxs.containsKey(itemId)) continue;
            firstRowIdxs.put(itemId, i.value());
        }
        return firstRowIdxs;
    }

    public static boolean resolveMoveIntoOwnSubtree(long moveTo, long row, HierarchyHelper hh, ForestSource ufs, @Nullable SyncLogger debugLog) throws StructureException {
        if (hh.isInSubtree(moveTo, row)) {
            long parentRow = hh.getParent(row);
            if (debugLog != null) {
                debugLog.debug("moving parent", debugLog.row(moveTo), "out of child subtree", debugLog.row(row));
            }
            SyncUtil.move(ufs, (LongList)new LongList.Single(moveTo), parentRow, row, null);
            hh.recordMove(moveTo, parentRow);
            return true;
        }
        return false;
    }

    @NotNull
    private static ItemIdentity getItemId(RowManager rowManager, long row, boolean followSymlinks) {
        ItemIdentity itemId = rowManager.getRow(row).getItemId();
        if (followSymlinks) {
            while (CoreIdentities.isLoopMarker(itemId)) {
                itemId = rowManager.getRow(itemId.getLongId()).getItemId();
            }
        }
        return itemId;
    }

    public static long getFilterId(@NotNull Map<String, ?> params, @NotNull String name, SearchRequestService searchService, JiraWebActionSupport action) {
        long filterId;
        Pattern filterPattern;
        Matcher m;
        String sf = StructureUtil.getSingleParameter(params, name);
        if (sf != null && (m = (filterPattern = Pattern.compile("filter-(\\d+)")).matcher(sf)).matches() && (filterId = StructureUtil.lv(m.group(1), 0L)) > 0L) {
            JiraServiceContextImpl context = new JiraServiceContextImpl(StructureAuth.getUser());
            SearchRequest filter = searchService.getFilter((JiraServiceContext)context, Long.valueOf(filterId));
            ErrorCollection ec = context.getErrorCollection();
            if (ec.hasAnyErrors()) {
                action.addError(name, StringUtils.join((Collection)ec.getErrorMessages(), (String)"\n"));
                return 0L;
            }
            if (filter == null) {
                action.addError(name, action.getText("s.sync.error.bad-filter"));
            }
            return filterId;
        }
        action.addError(name, action.getText("s.sync.error.no-filter-id"));
        return 0L;
    }

    @Nullable
    public static String getJqlQuery(@NotNull Map<String, ?> params, @NotNull String name, StructurePluginHelper helper, JiraWebActionSupport action) {
        Query query;
        String jql = StructureUtil.getSingleParameter(params, name);
        if (StringUtils.isBlank((String)jql)) {
            action.addError(name, action.getText("s.sync.error.no-jql-query"));
            return null;
        }
        jql = jql.trim();
        try {
            query = helper.getJqlQueryParser().parseQuery(jql);
        }
        catch (JqlParseException e) {
            JqlParseErrorMessage jpem = StructureUtil.nnv(e.getParseErrorMessage(), JqlParseErrorMessages.genericParseError());
            action.addError(name, jpem.getLocalizedErrorMessage(helper.getI18n()));
            return null;
        }
        MessageSet errors = helper.validateQuery(StructureAuth.getUser(), query);
        if (errors.hasAnyErrors()) {
            action.addError(name, StringUtils.join((Collection)errors.getErrorMessages(), (String)"\n"));
            return null;
        }
        return jql;
    }
}

