/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.row;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface StructureRow {
    public static final StructureRow ROW_ZERO = new ZeroRow();

    public long getRowId();

    @NotNull
    public ItemIdentity getItemId();

    public long getSemantics();

    @Nullable
    public <I> I getItem(@NotNull Class<I> var1);

    public static final class ZeroRow
    implements StructureRow {
        @Override
        public long getRowId() {
            return 0L;
        }

        @Override
        @NotNull
        public ItemIdentity getItemId() {
            return ItemIdentity.ITEM_ZERO;
        }

        @Override
        @Nullable
        public <I> I getItem(@NotNull Class<I> itemClass) {
            return null;
        }

        @Override
        public long getSemantics() {
            return 0L;
        }

        public String toString() {
            return this.getRowId() + ":" + this.getItemId();
        }
    }
}

