/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.row;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongCollector;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.item.CoreIdentities;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.MissingRowException;
import com.almworks.jira.structure.api.row.RowMapper;
import com.almworks.jira.structure.api.row.StructureRow;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface RowManager {
    @NotNull
    public StructureRow getRow(long var1) throws MissingRowException;

    @NotNull
    @Internal
    public StructureRow getRow(long var1, boolean var3) throws MissingRowException;

    public long createRow(@NotNull ItemIdentity var1, long var2);

    @NotNull
    default public LongIterator findRows(@Nullable ItemIdentity itemId) {
        LongArray rows = new LongArray();
        this.findRows(itemId, arg_0 -> ((LongArray)rows).add(arg_0));
        return rows.iterator();
    }

    default public void findRows(@Nullable ItemIdentity itemId, @NotNull LongConsumer consumer) {
        this.findRows(itemId, (long i) -> {
            consumer.accept(i);
            return true;
        });
    }

    public void findRows(@Nullable ItemIdentity var1, @NotNull LongPredicate var2);

    public void scanRows(@Nullable LongIterator var1, boolean var2, @Nullable LongCollector var3, @NotNull Predicate<StructureRow> var4) throws MissingRowException;

    @NotNull
    default public <C extends LongCollector> C collectIssueIds(@Nullable LongIterable rows, boolean sorted, @NotNull C issuesCollector) {
        if (rows == null) {
            return issuesCollector;
        }
        this.scanRows(rows.iterator(), sorted, LongCollector.DUMMY, row -> {
            ItemIdentity itemId = row.getItemId();
            if (CoreIdentities.isIssue(itemId)) {
                issuesCollector.add(itemId.getLongId());
            }
            return true;
        });
        return issuesCollector;
    }

    default public <C extends LongCollector> C collectIssueIds(@Nullable LongIterable rows, C issuesCollector) {
        return this.collectIssueIds(rows, false, issuesCollector);
    }

    @Internal
    @NotNull
    public RowMapper createMapper(@NotNull Forest var1);
}

