/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.item;

import com.almworks.jira.structure.api.item.CoreIdentities;
import com.atlassian.annotations.PublicApi;
import java.io.Serializable;
import java.text.ParseException;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
@Immutable
public abstract class ItemIdentity
implements Serializable {
    private static final long serialVersionUID = 201611180000L;
    public static final ItemIdentity ITEM_ZERO = ItemIdentity.longId("0", 0L);
    @NotNull
    private final String myItemType;

    private ItemIdentity(@NotNull String itemType) {
        if (StringUtils.isBlank((String)itemType)) {
            throw new IllegalArgumentException("item type must not be empty");
        }
        if (itemType.length() > 190) {
            throw new IllegalArgumentException("item type must not be longer than 190 chars");
        }
        this.myItemType = itemType;
    }

    @NotNull
    public String getItemType() {
        return this.myItemType;
    }

    public boolean isStringId() {
        return false;
    }

    @NotNull
    public String getStringId() {
        throw new UnsupportedOperationException("Not a string ID");
    }

    public boolean isLongId() {
        return false;
    }

    public long getLongId() {
        throw new UnsupportedOperationException("Not a long ID");
    }

    @NotNull
    public static ItemIdentity stringId(@NotNull String itemType, @NotNull String stringId) {
        return new StringIdentity(itemType, stringId);
    }

    @NotNull
    public static ItemIdentity longId(@NotNull String itemType, long longId) {
        return new LongIdentity(itemType, longId);
    }

    @NotNull
    public static ItemIdentity parse(@Nullable String id) throws ParseException {
        if (id == null || id.isEmpty()) {
            throw new ParseException("cannot parse empty id", 0);
        }
        int k = id.indexOf(47);
        if (k < 0) {
            try {
                long longId = Long.parseLong(id);
                return CoreIdentities.issue(longId);
            }
            catch (NumberFormatException e) {
                throw new ParseException("unknown id format [" + id + "]", id.length());
            }
        }
        if (k == 0) {
            throw new ParseException("empty type id [" + id + "]", 0);
        }
        if (k == id.length() - 1) {
            throw new ParseException("unexpected end of line [" + id + "]", id.length());
        }
        String typeId = id.substring(0, k);
        if (id.charAt(k + 1) == '/') {
            String sid = id.substring(k + 2);
            if (sid.isEmpty()) {
                throw new ParseException("empty sid [" + id + "]", k + 2);
            }
            try {
                return ItemIdentity.stringId(typeId, sid);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e.getMessage(), k + 1);
            }
        }
        String lid = id.substring(k + 1);
        if (lid.isEmpty()) {
            throw new ParseException("empty id [" + id + "]", k + 1);
        }
        try {
            return ItemIdentity.longId(typeId, Long.parseLong(lid));
        }
        catch (NumberFormatException e) {
            throw new ParseException("bad id format [" + id + "]", k + 1);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), k + 1);
        }
    }

    @PublicApi
    public static final class LongIdentity
    extends ItemIdentity
    implements Serializable {
        private static final long serialVersionUID = 201611180000L;
        private final long myLongId;

        private LongIdentity(@NotNull String itemType, long longId) {
            super(itemType);
            this.myLongId = longId;
        }

        @Override
        public boolean isLongId() {
            return true;
        }

        @Override
        public long getLongId() {
            return this.myLongId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongIdentity that = (LongIdentity)o;
            return this.myLongId == that.myLongId && this.getItemType().equals(that.getItemType());
        }

        public int hashCode() {
            return (int)(this.myLongId ^ this.myLongId >>> 32) * 31 + this.getItemType().hashCode();
        }

        public String toString() {
            return this.getItemType() + "/" + this.myLongId;
        }
    }

    @PublicApi
    public static final class StringIdentity
    extends ItemIdentity
    implements Serializable {
        private static final long serialVersionUID = 201611180000L;
        @NotNull
        private final String myStringId;

        private StringIdentity(@NotNull String itemType, @NotNull String stringId) {
            super(itemType);
            if (StringUtils.isBlank((String)stringId)) {
                throw new IllegalArgumentException("string id must not be empty");
            }
            if (stringId.length() > 190) {
                throw new IllegalArgumentException("string id must not be longer than 190 chars");
            }
            this.myStringId = stringId;
        }

        @Override
        public boolean isStringId() {
            return true;
        }

        @Override
        @NotNull
        public String getStringId() {
            return this.myStringId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringIdentity that = (StringIdentity)o;
            return this.myStringId.equals(that.myStringId) && this.getItemType().equals(that.getItemType());
        }

        public int hashCode() {
            return this.myStringId.hashCode() * 31 + this.getItemType().hashCode();
        }

        public String toString() {
            return this.getItemType() + "//" + this.myStringId;
        }
    }
}

