/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.item;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.util.JiraFunc;
import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class CoreIdentities {
    public static final String ANONYMOUS_USER_ID = "-";
    public static final ItemIdentity NEW_ISSUE = CoreIdentities.issue(Long.MAX_VALUE);
    public static final ItemIdentity NEW_FOLDER = CoreIdentities.folder(Long.MAX_VALUE);
    public static final ItemIdentity NEW_GENERATOR = CoreIdentities.generator(Long.MAX_VALUE);
    public static final ItemIdentity MISSING_ITEM = ItemIdentity.longId("com.almworks.jira.structure:type-missing", 0L);

    private CoreIdentities() {
    }

    public static ItemIdentity user(@Nullable ApplicationUser user) {
        return CoreIdentities.user(user == null ? null : user.getKey());
    }

    public static ItemIdentity user(@Nullable String userKey) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-user", userKey == null ? ANONYMOUS_USER_ID : userKey);
    }

    public static ItemIdentity group(@NotNull String groupId) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-group", groupId);
    }

    public static ItemIdentity group(@NotNull Group group) {
        return CoreIdentities.group(group.getName());
    }

    public static ItemIdentity project(Project value) {
        return CoreIdentities.project(value.getId());
    }

    public static ItemIdentity project(long projectId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-project", projectId);
    }

    public static ItemIdentity priority(Priority value) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-priority", value.getId());
    }

    public static ItemIdentity status(Status value) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-status", value.getId());
    }

    public static ItemIdentity resolution(Resolution value) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-resolution", value.getId());
    }

    public static ItemIdentity label(Label value) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-label", value.getLabel());
    }

    public static ItemIdentity issueType(IssueType value) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-issuetype", value.getId());
    }

    public static ItemIdentity issue(long issueId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-issue", issueId);
    }

    public static ItemIdentity issue(Issue issue) {
        return CoreIdentities.issue(issue.getId());
    }

    public static ItemIdentity version(@NotNull Version version) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-version", version.getId());
    }

    public static ItemIdentity version(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-version", id);
    }

    public static ItemIdentity versionName(String name) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-version-name", CoreIdentities.canonicalVersionName(name));
    }

    public static ItemIdentity versionName(@NotNull Version version) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-version-name", JiraFunc.CANONICAL_VERSION_NAME.la(version));
    }

    public static ItemIdentity generator(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-generator", id);
    }

    public static ItemIdentity loopMarker(long rowId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-loop-marker", rowId);
    }

    public static ItemIdentity component(ProjectComponent component) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-project-component", component.getId());
    }

    public static ItemIdentity component(long id) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-project-component", id);
    }

    public static ItemIdentity option(Option option) {
        Long optionId = option.getOptionId();
        return optionId == null ? null : ItemIdentity.longId("com.almworks.jira.structure:type-cf-option", optionId);
    }

    public static ItemIdentity option(long optionId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-cf-option", optionId);
    }

    public static ItemIdentity structure(long structureId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-structure", structureId);
    }

    public static ItemIdentity sprint(long sprintId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-sprint", sprintId);
    }

    public static ItemIdentity tempoAccount(int accountId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-tempo-account", accountId);
    }

    public static ItemIdentity i18nFolder(@NotNull String i18nKey) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-folder", i18nKey);
    }

    public static ItemIdentity textFolder(@NotNull String text) {
        return ItemIdentity.stringId("com.almworks.jira.structure:type-folder", "/" + text);
    }

    public static ItemIdentity folder(long folderId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-folder", folderId);
    }

    public static ItemIdentity sdRequestType(int requestTypeId) {
        return ItemIdentity.longId("com.almworks.jira.structure:type-sd-request-type", requestTypeId);
    }

    public static boolean isIssue(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-issue");
    }

    public static boolean isProject(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-project");
    }

    public static boolean isComponent(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-project-component");
    }

    public static boolean isVersion(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-version");
    }

    public static boolean isGenerator(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-generator");
    }

    public static boolean isStructure(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-structure");
    }

    public static boolean isLoopMarker(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-loop-marker");
    }

    public static boolean isTempoAccount(ItemIdentity itemId) {
        return CoreIdentities.isLongType(itemId, "com.almworks.jira.structure:type-tempo-account");
    }

    public static boolean isVersionName(ItemIdentity itemId) {
        return CoreIdentities.isStringType(itemId, "com.almworks.jira.structure:type-version-name");
    }

    public static String canonicalVersionName(String versionName) {
        return versionName == null ? null : versionName.trim().toLowerCase(Locale.ROOT);
    }

    private static boolean isStringType(@Nullable ItemIdentity itemId, @NotNull String itemType) {
        return itemId != null && itemType.equals(itemId.getItemType()) && itemId.isStringId();
    }

    private static boolean isLongType(@Nullable ItemIdentity itemId, @NotNull String itemType) {
        return itemId != null && itemType.equals(itemId.getItemType()) && itemId.isLongId();
    }
}

