/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.forest.item;

import com.almworks.integers.IntArray;
import com.almworks.integers.LongArray;
import com.almworks.integers.WritableIntList;
import com.almworks.integers.WritableLongList;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.forest.raw.ArrayForest;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.ItemResolver;
import com.almworks.jira.structure.api.row.MissingRowException;
import com.almworks.jira.structure.api.row.SimpleRow;
import com.almworks.jira.structure.api.row.StructureRow;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ItemForestBuffer
implements ItemForest {
    private final ItemResolver myItemResolver;
    private final List<ItemIdentity> myItems = new ArrayList<ItemIdentity>();
    private final LongArray myRows = new LongArray();
    private final IntArray myDepths = new IntArray();
    private final ArrayForest myForest = new ArrayForest((WritableLongList)this.myRows, (WritableIntList)this.myDepths, true);

    public ItemForestBuffer(ItemResolver itemResolver) {
        this.myItemResolver = itemResolver;
    }

    @Override
    @NotNull
    public Forest getForest() {
        return this.myForest;
    }

    @Override
    @NotNull
    public StructureRow getRow(long rowId) throws MissingRowException {
        int idx = (int)(-rowId) - 1;
        if (idx < 0 || idx >= this.myItems.size()) {
            throw new MissingRowException(rowId);
        }
        return new SimpleRow(rowId, this.myItems.get(idx), 0L, this.myItemResolver);
    }

    public void clear() {
        this.myItems.clear();
        this.myRows.clear();
        this.myDepths.clear();
    }

    public long add(ItemIdentity item) {
        return this.add(item, 0);
    }

    public long add(ItemIdentity item, int depth) {
        int idx = this.myItems.size();
        assert (idx != 0 ? this.myDepths.get(idx - 1) - depth >= -1 : depth == 0) : idx + " " + depth + " " + this.myDepths + " " + item;
        long fakeRowId = -idx - 1;
        this.myItems.add(item);
        this.myRows.add(fakeRowId);
        this.myDepths.add(depth);
        return fakeRowId;
    }

    public ItemIdentity getItemId(int idx) {
        return this.myItems.get(idx);
    }
}

