/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.forest.item;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongIterator;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.forest.raw.ArrayForest;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.row.MissingRowException;
import com.almworks.jira.structure.api.row.StructureRow;
import com.atlassian.annotations.PublicApi;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@PublicApi
@Immutable
public final class ImmutableItemForest
implements ItemForest {
    public static final ItemForest EMPTY = new ImmutableItemForest(new ArrayForest().makeImmutable(), (Map<Long, StructureRow>)ImmutableMap.of());
    private final Forest myForest;
    private final Map<Long, StructureRow> myRows;

    private ImmutableItemForest(@NotNull Forest forest, @NotNull Map<Long, StructureRow> rows) {
        this.myForest = forest;
        this.myRows = rows;
    }

    public static ImmutableItemForest of(@NotNull Forest forest, @NotNull Map<Long, StructureRow> rows) {
        ImmutableItemForest.checkAllRowsPresent(forest, rows);
        forest = new ArrayForest(forest).makeImmutable();
        rows = ImmutableMap.copyOf(rows);
        return new ImmutableItemForest(forest, (Map<Long, StructureRow>)rows);
    }

    public static ImmutableItemForest of(@NotNull StructureRow row) {
        return new ImmutableItemForest(new ArrayForest(row.getRowId()), Collections.singletonMap(row.getRowId(), row));
    }

    private static void checkAllRowsPresent(@NotNull Forest forest, @NotNull Map<Long, ?> rows) throws IllegalArgumentException {
        LongArray missing = null;
        for (LongIterator it : forest.getRows()) {
            if (rows.get(it.value()) != null) continue;
            if (missing == null) {
                missing = new LongArray();
            }
            missing.add(it.value());
        }
        if (missing != null) {
            throw new IllegalArgumentException("No data for " + missing);
        }
    }

    @NotNull
    public static ImmutableItemForest copy(@NotNull ItemForest copyFrom) {
        if (copyFrom instanceof ImmutableItemForest) {
            return (ImmutableItemForest)copyFrom;
        }
        ArrayForest forest = new ArrayForest(copyFrom.getForest()).makeImmutable();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (LongIterator it : forest.getRows()) {
            builder.put((Object)it.value(), (Object)copyFrom.getRow(it.value()));
        }
        return new ImmutableItemForest(forest, (Map<Long, StructureRow>)builder.build());
    }

    @NotNull
    public static ImmutableItemForest copySubtree(@NotNull ItemForest copyFrom, long rootId) {
        Forest subtree = copyFrom.getForest().subtree(rootId);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (LongIterator it : subtree.getRows()) {
            builder.put((Object)it.value(), (Object)copyFrom.getRow(it.value()));
        }
        return new ImmutableItemForest(subtree, (Map<Long, StructureRow>)builder.build());
    }

    @Override
    @NotNull
    public Forest getForest() {
        return this.myForest;
    }

    @Override
    @NotNull
    public StructureRow getRow(long rowId) throws MissingRowException {
        StructureRow row = this.myRows.get(rowId);
        if (row == null) {
            throw new MissingRowException(rowId);
        }
        return row;
    }
}

