/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.reduce;

import com.almworks.integers.LongSet;
import com.almworks.jira.structure.api.attribute.AttributeLoaderSecurity;
import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AttributeCachingStrategy;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.BulkAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.reduce.SingleDependencyReducingAggregateLoader;
import com.almworks.jira.structure.api.cache.access.ForestAccessCache;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import org.jetbrains.annotations.NotNull;

public abstract class SecureSingleDependencyReducingAggregateLoader<T>
extends SingleDependencyReducingAggregateLoader<T>
implements BulkAttributeLoader {
    private final ForestAccessCache myForestAccessCache;

    protected SecureSingleDependencyReducingAggregateLoader(AttributeSpec<T> spec, AttributeSpec<T> dependency, ForestAccessCache forestAccessCache) {
        super(spec, dependency);
        this.myForestAccessCache = forestAccessCache;
    }

    @Override
    @NotNull
    protected AttributeValue<T> getSelfValue(AttributeLoader.AggregateContext<T> context) {
        if (AttributeLoaderSecurity.isRowInvisible(context)) {
            return AttributeValue.undefined();
        }
        return super.getSelfValue(context);
    }

    @Override
    public void preload(@NotNull LongSet rowIds, @NotNull ItemForest forest, @NotNull AttributeContext context) {
        AttributeLoaderSecurity.collectInvisibleRows(rowIds, context, this.myForestAccessCache);
    }

    @Override
    public AttributeCachingStrategy getCachingStrategy() {
        return AttributeCachingStrategy.MUST_NOT;
    }
}

