/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.integers.LongSet;
import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AbstractAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeCachingStrategy;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.BulkAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.ForestDependencyType;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.util.La;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CompositeAttributeLoader<T, Loader extends AttributeLoader<T>, LoaderValue, Params, LoaderContext extends AttributeLoader.Context>
extends AbstractAttributeLoader<T> {
    public static final La<AttributeLoader<?>, Boolean> UNIVERSAL_LOADER = new La<AttributeLoader<?>, Boolean>(){

        @Override
        public Boolean la(AttributeLoader<?> argument) {
            return argument.isEveryItemTypeSupported();
        }
    };
    public static final Predicate<AttributeLoader<?>> UNIVERSAL_LOADER_PRED = UNIVERSAL_LOADER.toPred();
    public static final Predicate<AttributeLoader<?>> SPECIFIC_LOADER_PRED = UNIVERSAL_LOADER.not().toPred();
    private final List<Loader> myLoaders;
    private final Collection<Loader> mySpecificLoaders;
    private final Collection<Loader> myUniversalLoaders;
    private final AttributeCachingStrategy myCachingStrategy;

    private CompositeAttributeLoader(AttributeSpec<T> spec, @NotNull List<Loader> loaders) {
        super(spec);
        this.myLoaders = loaders;
        this.mySpecificLoaders = Collections2.filter(this.myLoaders, SPECIFIC_LOADER_PRED);
        this.myUniversalLoaders = Collections2.filter(this.myLoaders, UNIVERSAL_LOADER_PRED);
        AttributeLoader shouldLoader = null;
        AttributeLoader mustNotLoader = null;
        for (AttributeLoader loader : loaders) {
            if (loader.getCachingStrategy() == AttributeCachingStrategy.SHOULD) {
                shouldLoader = loader;
            }
            if (loader.getCachingStrategy() != AttributeCachingStrategy.MUST_NOT) continue;
            mustNotLoader = loader;
            break;
        }
        this.myCachingStrategy = mustNotLoader != null ? AttributeCachingStrategy.MUST_NOT : (shouldLoader != null ? AttributeCachingStrategy.SHOULD : AttributeCachingStrategy.MAY);
    }

    public static <T> AttributeLoader<T> create(AttributeSpec<T> spec, List<AttributeLoader<T>> loaders) {
        if (loaders == null || loaders.isEmpty()) {
            throw new IllegalArgumentException("empty or null loaders");
        }
        ForestDependencyType depType = ForestDependencyType.getType(loaders.get(0));
        for (int i = 1; i < loaders.size(); ++i) {
            if (depType.is(loaders.get(i))) continue;
            throw new IllegalArgumentException("cannot have different forest dependency in the composite loader");
        }
        switch (depType) {
            case INDEPENDENT: {
                return new ForestIndependentLoader(spec, loaders);
            }
            case AGGREGATE: {
                return new AggregateLoader(spec, loaders);
            }
            case PROPAGATE: {
                return new PropagateLoader(spec, loaders);
            }
        }
        throw new IllegalArgumentException("unknown forest dependency type " + (Object)((Object)depType));
    }

    @Override
    public boolean isEveryItemTypeSupported() {
        return !this.myUniversalLoaders.isEmpty();
    }

    @Override
    public boolean isItemTypeSupported(String itemType) {
        if (this.isEveryItemTypeSupported()) {
            return true;
        }
        for (AttributeLoader loader : this.mySpecificLoaders) {
            if (!loader.isItemTypeSupported(itemType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AttributeCachingStrategy getCachingStrategy() {
        return this.myCachingStrategy;
    }

    @Override
    @NotNull
    public Set<? extends AttributeSpec<?>> getAttributeDependencies() {
        HashSet specs = new HashSet();
        for (AttributeLoader loader : this.myLoaders) {
            specs.addAll(loader.getAttributeDependencies());
        }
        return specs;
    }

    protected final AttributeValue<LoaderValue> loadValue(LoaderContext context, Params additionalParams) {
        AttributeValue<LoaderValue> result;
        String itemType = context.getRow().getItemId().getItemType();
        for (AttributeLoader loader : this.mySpecificLoaders) {
            if (!loader.isItemTypeSupported(itemType) || (result = this.apply(loader, additionalParams, context)) == null || result.isEmpty()) continue;
            return result;
        }
        for (AttributeLoader loader : this.myUniversalLoaders) {
            result = this.apply(loader, additionalParams, context);
            if (result == null || result.isEmpty()) continue;
            return result;
        }
        return AttributeValue.undefined();
    }

    protected abstract AttributeValue<LoaderValue> apply(Loader var1, Params var2, LoaderContext var3);

    public boolean hasBulkLoaders() {
        return this.myLoaders.stream().anyMatch(CompositeAttributeLoader::isBulkLoader);
    }

    public static boolean isBulkLoader(AttributeLoader<?> loader) {
        return loader instanceof CompositeAttributeLoader ? ((CompositeAttributeLoader)loader).hasBulkLoaders() : loader instanceof BulkAttributeLoader;
    }

    public void preload(@NotNull LongSet rowIds, @NotNull ItemForest forest, @NotNull AttributeContext context) {
        this.myLoaders.forEach(loader -> CompositeAttributeLoader.preload(loader, rowIds, forest, context));
    }

    public static void preload(AttributeLoader<?> loader, @NotNull LongSet rowIds, @NotNull ItemForest forest, @NotNull AttributeContext context) {
        if (loader instanceof BulkAttributeLoader) {
            ((BulkAttributeLoader)((Object)loader)).preload(rowIds, forest, context);
        } else if (loader instanceof CompositeAttributeLoader) {
            ((CompositeAttributeLoader)loader).preload(rowIds, forest, context);
        }
    }

    private static class PropagateLoader<T>
    extends CompositeAttributeLoader<T, AttributeLoader.Propagate<T>, List<AttributeValue<T>>, List<StructureRow>, AttributeLoader.PropagateContext<T>>
    implements AttributeLoader.Propagate<T> {
        private PropagateLoader(AttributeSpec<T> spec, @NotNull List<AttributeLoader.Propagate<T>> loaders) {
            super(spec, loaders);
        }

        @Override
        public List<AttributeValue<T>> loadChildrenValues(AttributeValue<T> rowValue, List<StructureRow> children, AttributeLoader.PropagateContext<T> context) {
            return (List)this.loadValue(context, children).getValue();
        }

        @Override
        protected AttributeValue<List<AttributeValue<T>>> apply(AttributeLoader.Propagate<T> loader, List<StructureRow> children, AttributeLoader.PropagateContext<T> context) {
            List<AttributeValue<T>> childrenValues = loader.loadChildrenValues(context.getAttributeValue(), children, context);
            if (childrenValues != null) {
                for (AttributeValue<T> childrenValue : childrenValues) {
                    if (childrenValue == null || !childrenValue.isDefined()) continue;
                    return AttributeValue.of(childrenValues);
                }
            }
            return AttributeValue.undefined();
        }
    }

    private static class AggregateLoader<T>
    extends CompositeAttributeLoader<T, AttributeLoader.Aggregate<T>, T, List<AttributeValue<T>>, AttributeLoader.AggregateContext<T>>
    implements AttributeLoader.Aggregate<T> {
        private AggregateLoader(AttributeSpec<T> spec, @NotNull List<AttributeLoader.Aggregate<T>> loaders) {
            super(spec, loaders);
        }

        @Override
        public AttributeValue<T> loadValue(List<AttributeValue<T>> childrenValues, AttributeLoader.AggregateContext<T> context) {
            return this.loadValue(context, childrenValues);
        }

        @Override
        protected AttributeValue<T> apply(AttributeLoader.Aggregate<T> loader, List<AttributeValue<T>> childrenValues, AttributeLoader.AggregateContext<T> context) {
            return loader.loadValue(childrenValues, context);
        }
    }

    private static class ForestIndependentLoader<T>
    extends CompositeAttributeLoader<T, AttributeLoader.ForestIndependent<T>, T, Void, AttributeLoader.Context>
    implements AttributeLoader.ForestIndependent<T> {
        private ForestIndependentLoader(AttributeSpec<T> spec, @NotNull List<AttributeLoader.ForestIndependent<T>> loaders) {
            super(spec, loaders);
        }

        @Override
        public AttributeValue<T> loadValue(StructureRow row, AttributeLoader.Context context) {
            return this.loadValue(context, null);
        }

        @Override
        protected AttributeValue<T> apply(AttributeLoader.ForestIndependent<T> loader, Void additionalParams, AttributeLoader.Context context) {
            return loader.loadValue(context.getRow(), context);
        }
    }
}

