/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.TrailItemSet;
import com.almworks.jira.structure.api.item.ItemIdentity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeValue<T> {
    private static final AttributeValue BARE_UNDEFINED = new AttributeValue<Object>(null, false, false, null, null);
    private static final AttributeValue BARE_ERROR = new AttributeValue<Object>(null, false, true, null, null);
    private final T myValue;
    private final boolean myDefined;
    private final boolean myError;
    private final TrailItemSet myAdditionalDataTrail;
    private final Object myLoaderData;

    private AttributeValue(T value, boolean defined, boolean error, TrailItemSet additionalDataTrail, Object loaderData) {
        this.myValue = value;
        this.myDefined = defined;
        this.myError = error;
        this.myAdditionalDataTrail = additionalDataTrail;
        this.myLoaderData = loaderData;
    }

    @NotNull
    public static <T> AttributeValue<T> derived(T value, AttributeValue<?> dependentResult) {
        return new AttributeValue<T>(value, value != null, false, dependentResult.getAdditionalDataTrail(), null);
    }

    @NotNull
    public static <T> AttributeValue<T> of(@Nullable T value) {
        return new AttributeValue<T>(value, true, false, null, null);
    }

    @NotNull
    public static <T> AttributeValue<T> ofNullable(@Nullable T value) {
        return value == null ? AttributeValue.undefined() : AttributeValue.of(value);
    }

    public static <T> AttributeValue<T> undefined() {
        return BARE_UNDEFINED;
    }

    public AttributeValue<T> withTrail(ItemIdentity trailItem) {
        TrailItemSet trail = this.myAdditionalDataTrail;
        if (trail == null) {
            trail = TrailItemSet.None.NONE;
        }
        trail = trail.expand(trailItem);
        return new AttributeValue<T>(this.myValue, this.myDefined, this.myError, trail, this.myLoaderData);
    }

    public AttributeValue<T> withTrail(TrailItemSet trail) {
        if (this.myAdditionalDataTrail != null) {
            throw new IllegalStateException("trail already set");
        }
        return new AttributeValue<T>(this.myValue, this.myDefined, this.myError, trail, this.myLoaderData);
    }

    public AttributeValue<T> withData(Object loaderData) {
        return new AttributeValue<T>(this.myValue, this.myDefined, this.myError, this.myAdditionalDataTrail, loaderData);
    }

    public T getValue() {
        return this.myValue;
    }

    public boolean isDefined() {
        return this.myDefined;
    }

    public boolean isError() {
        return this.myError;
    }

    public boolean isEmpty() {
        return !this.myDefined && this.myLoaderData == null;
    }

    @Nullable
    public <D> D getLoaderData(Class<D> valueClass) {
        return valueClass.isInstance(this.myLoaderData) ? (D)valueClass.cast(this.myLoaderData) : null;
    }

    @NotNull
    public TrailItemSet getAdditionalDataTrail() {
        return this.myAdditionalDataTrail == null ? TrailItemSet.None.NONE : this.myAdditionalDataTrail;
    }

    public <X> AttributeValue<X> cast(AttributeSpec<X> spec) {
        if (this.myValue != null && !spec.getFormat().getValueClass().isInstance(this.myValue)) {
            assert (false) : this + " " + spec;
            return null;
        }
        return this;
    }

    public static <T> AttributeValue<T> error() {
        return BARE_ERROR;
    }

    public String toString() {
        if (this.myError) {
            return "<!>";
        }
        if (!this.myDefined) {
            return "<?>";
        }
        return String.valueOf(this.myValue);
    }
}

