/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AbstractAggregateLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.item.ItemIdentity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDistinctAggregateLoader<T>
extends AbstractAggregateLoader<T> {
    public AbstractDistinctAggregateLoader(AttributeSpec<T> spec) {
        super(spec);
    }

    @Override
    public AttributeValue<T> loadValue(List<AttributeValue<T>> childrenValues, AttributeLoader.AggregateContext<T> context) {
        T value;
        HashMap<ItemIdentity, T> values = new HashMap<ItemIdentity, T>();
        for (AttributeValue<T> childValue : childrenValues) {
            Map childData;
            if (childValue == null || !childValue.isDefined() || (childData = childValue.getLoaderData(Map.class)) == null) continue;
            values.putAll(childData);
        }
        ItemIdentity itemId = context.getRow().getItemId();
        if (!values.containsKey(itemId) && (value = this.getRowValue(context)) != null) {
            values.put(itemId, value);
        }
        Object total = this.combine(values.values(), context);
        return AttributeValue.of(total).withData(Collections.unmodifiableMap(values));
    }

    protected abstract T getRowValue(AttributeLoader.AggregateContext<T> var1);

    protected abstract T combine(Collection<T> var1, AttributeLoader.AggregateContext<T> var2);
}

