/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.forest.item;

import com.almworks.integers.IntArray;
import com.almworks.integers.LongArray;
import com.almworks.integers.LongIterator;
import com.almworks.integers.WritableIntList;
import com.almworks.integers.WritableLongList;
import com.almworks.jira.structure.api.forest.item.ImmutableItemForest;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.forest.item.ItemForestBuilder;
import com.almworks.jira.structure.api.forest.raw.ArrayForest;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.ItemResolver;
import com.almworks.jira.structure.api.row.SimpleRow;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.util.JiraComponents;
import com.almworks.jira.structure.api.util.RowTree;
import com.atlassian.annotations.PublicApi;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.jetbrains.annotations.NotNull;

@PublicApi
@NotThreadSafe
public final class ItemForestBuilderImpl
implements ItemForestBuilder<ItemForestBuilderImpl> {
    private final ItemResolver myItemResolver = JiraComponents.getOSGiComponentInstanceOfType(ItemResolver.class);
    private final RowTree myTree = new RowTree();
    private final Map<Long, StructureRow> myRows = new HashMap<Long, StructureRow>();
    private long myNextRowId = -100L;
    private RowTree.Node myCurrentParent = this.myTree.getSuperRoot();
    private RowTree.Node myCurrentRow = null;

    @Override
    @NotNull
    public ItemForestBuilderImpl nextRow(@NotNull ItemIdentity itemId) {
        return this.nextRow0(itemId, 0L);
    }

    @Override
    @NotNull
    public ItemForestBuilderImpl nextRow(@NotNull ItemIdentity itemId, long semantics) {
        return this.nextRow0(itemId, semantics);
    }

    @NotNull
    private ItemForestBuilderImpl nextRow0(@NotNull ItemIdentity itemId, long semantics) {
        long rowId = this.myNextRowId--;
        StructureRow row = SimpleRow.create(rowId, itemId, semantics, this.myItemResolver);
        this.myRows.put(rowId, row);
        this.myCurrentRow = this.myTree.insertNode(rowId, 0, this.myCurrentParent, this.myCurrentRow);
        return this;
    }

    @Override
    @NotNull
    public ItemForestBuilderImpl nextLevel() {
        if (this.myCurrentRow == null) {
            throw new IllegalStateException();
        }
        this.myCurrentParent = this.myCurrentRow;
        this.myCurrentRow = null;
        return this;
    }

    @Override
    @NotNull
    public ItemForestBuilderImpl prevLevel() {
        if (this.myCurrentRow == null) {
            throw new IllegalStateException();
        }
        if (this.myCurrentParent == this.myTree.getSuperRoot()) {
            throw new IllegalStateException();
        }
        this.myCurrentRow = this.myCurrentRow.getParent();
        this.myCurrentParent = this.myCurrentRow.getParent();
        return this;
    }

    @Override
    @NotNull
    public ItemForestBuilderImpl nextFragment(@NotNull ItemForest fragment) {
        Forest forest = fragment.getForest();
        if (forest.isEmpty()) {
            return this;
        }
        LongArray rows = new LongArray();
        for (LongIterator it : forest.getRows()) {
            long rowId;
            StructureRow row = fragment.getRow(it.value());
            --this.myNextRowId;
            this.myRows.put(rowId, SimpleRow.create(rowId, row.getItemId(), row.getSemantics(), this.myItemResolver));
            rows.add(rowId);
        }
        assert (this.myCurrentRow == null || this.myCurrentRow.getLastChild() == null) : "fixme - will set myCurrentRow incorrectly";
        ArrayForest copyForest = new ArrayForest((WritableLongList)rows, (WritableIntList)new IntArray(forest.getDepths()), true);
        this.myTree.appendForest(copyForest, this.myCurrentParent, this.myCurrentRow);
        this.myCurrentRow = this.myCurrentParent.getLastChild();
        return this;
    }

    @NotNull
    public ItemForest build() {
        return ImmutableItemForest.of(this.myTree.toForest(), this.myRows);
    }

    public long getCurrentRowId() {
        if (this.myCurrentRow == null) {
            throw new IllegalStateException("no current row");
        }
        return this.myCurrentRow.getRowId();
    }
}

