/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.basic.AbstractItemAttributeLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class ItemTypeAttributeLoader<A>
extends AbstractItemAttributeLoader<A> {
    protected final Set<String> myItemTypes;

    public ItemTypeAttributeLoader(AttributeSpec<A> spec, String ... itemTypes) {
        super(spec);
        if (itemTypes == null || itemTypes.length == 0) {
            throw new IllegalArgumentException("empty or null item types");
        }
        this.myItemTypes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(itemTypes)));
    }

    @Override
    public final boolean isItemTypeSupported(String itemType) {
        return this.myItemTypes.contains(itemType);
    }
}

