/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.settings;

import org.jetbrains.annotations.Nullable;

public enum AutoSwitchStrategy {
    AUTOSWITCH_OFF("off"),
    STRUCTURE_WITH_ISSUE("withIssue"),
    DEFAULT_STRUCTURE("default");

    public static final AutoSwitchStrategy PLUGIN_DEFAULT_AUTOSWITCH_STRATEGY;
    private final String myStringCode;

    private AutoSwitchStrategy(String stringCode) {
        this.myStringCode = stringCode;
    }

    public String getStringCode() {
        return this.myStringCode;
    }

    @Nullable
    public static AutoSwitchStrategy fromStringCode(String code) {
        if (code == null) {
            return null;
        }
        for (AutoSwitchStrategy strategy : AutoSwitchStrategy.values()) {
            if (!code.equals(strategy.getStringCode())) continue;
            return strategy;
        }
        return null;
    }

    static {
        PLUGIN_DEFAULT_AUTOSWITCH_STRATEGY = STRUCTURE_WITH_ISSUE;
    }
}

