/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.row;

import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongList;
import com.almworks.integers.LongListIterator;
import com.almworks.jira.structure.api.row.ShallowRow;
import com.almworks.jira.structure.api.row.SimpleRow;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.row.TransientRow;
import com.almworks.jira.structure.api.util.LongFilteringIterator;
import org.jetbrains.annotations.Nullable;

public class StructureRows {
    public static final long STARTING_TEMPORARY_ROW_ID = -100L;

    private StructureRows() {
    }

    public static void validateForestRowId(long rowId) {
        String error = StructureRows.getRowIdError(rowId);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    public static void validateForestRowIds(@Nullable LongList rows) {
        if (rows != null) {
            LongListIterator ii = rows.iterator();
            while (ii.hasNext()) {
                String error = StructureRows.getRowIdError(ii.nextValue());
                if (error == null) continue;
                throw new IllegalArgumentException("[" + ii.index() + "] " + error);
            }
        }
    }

    public static LongIterator withoutSuperRoot(LongIterator rowIterator) {
        return new LongFilteringIterator(rowIterator, row -> row != -1L);
    }

    public static LongIterable withoutSuperRoot(LongIterable rowIterable) {
        return () -> StructureRows.withoutSuperRoot(rowIterable.iterator());
    }

    public static boolean isSuperRoot(long rowId) {
        return rowId == -1L;
    }

    public static boolean isSuperRoot(StructureRow row) {
        return row != null && row.getRowId() == -1L;
    }

    private static String getRowIdError(long rowId) {
        if (rowId == 0L) {
            return "row ID must be non-zero";
        }
        if (rowId == -1L) {
            return "row ID -1 is reserved for super-root and cannot be used";
        }
        return null;
    }

    public static boolean isGenerator(StructureRow row) {
        return StructureRows.isItemType(row, "com.almworks.jira.structure:type-generator");
    }

    public static boolean isEffector(StructureRow row) {
        return StructureRows.isItemType(row, "com.almworks.jira.structure:type-effector");
    }

    public static boolean isAutomation(StructureRow row) {
        return StructureRows.isGenerator(row) || StructureRows.isEffector(row);
    }

    public static boolean isLoopMarker(StructureRow row) {
        return StructureRows.isItemType(row, "com.almworks.jira.structure:type-loop-marker");
    }

    public static boolean isItemType(StructureRow row, String itemType) {
        return itemType != null && row != null && itemType.equals(row.getItemId().getItemType());
    }

    public static boolean isTemporary(long rowId) {
        return rowId <= -100L;
    }

    public static long temporaryRow(int sequence) {
        if (sequence < 0) {
            throw new IllegalArgumentException("sequence " + sequence);
        }
        return -100L - (long)sequence;
    }

    public static boolean isItemVisibleForSure(StructureRow row) {
        return TransientRow.getDelegate(row) instanceof SimpleRow.Unchecked;
    }

    public static StructureRow makeShallow(StructureRow row) {
        return TransientRow.replaceDelegate(row, ShallowRow::copy);
    }

    public static StructureRow makeUnchecked(StructureRow row) {
        return TransientRow.replaceDelegate(row, SimpleRow::tryMakeUnchecked);
    }
}

