/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.forest.raw;

import com.almworks.integers.IntArray;
import com.almworks.integers.IntFindingIterator;
import com.almworks.integers.IntIterable;
import com.almworks.integers.IntIterator;
import com.almworks.integers.IntList;
import com.almworks.integers.LongArray;
import com.almworks.integers.LongCollections;
import com.almworks.integers.LongIntIterator;
import com.almworks.integers.LongIntIterators;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongList;
import com.almworks.integers.WritableIntList;
import com.almworks.integers.WritableLongList;
import com.almworks.jira.structure.api.error.StructureErrors;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.forest.raw.ForestChangeEventHandler;
import com.almworks.jira.structure.api.forest.raw.ForestIterationControl;
import com.almworks.jira.structure.api.forest.raw.ForestMergeStructureException;
import com.almworks.jira.structure.api.forest.raw.ForestParentChildrenClosure;
import com.almworks.jira.structure.api.forest.raw.ForestParentChildrenVisitor;
import com.almworks.jira.structure.api.forest.raw.ForestScanControl;
import com.almworks.jira.structure.api.forest.raw.ForestScanner;
import com.almworks.jira.structure.api.row.StructureRows;
import com.almworks.jira.structure.api.util.La;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayForest
implements Forest {
    private static final Logger logger = LoggerFactory.getLogger(ArrayForest.class);
    private WritableLongList myRows;
    private WritableIntList myDepths;
    private boolean myImmutable;

    public ArrayForest() {
        this((WritableLongList)new LongArray(), (WritableIntList)new IntArray(), true);
    }

    public ArrayForest(long row) {
        this((WritableLongList)LongArray.create((long[])new long[]{row}), (WritableIntList)IntArray.create((int[])new int[]{0}), true);
    }

    public ArrayForest(WritableLongList rows, WritableIntList depths, boolean reuseLists) {
        this.set(rows, depths, reuseLists);
    }

    public ArrayForest(LongList rows, IntList depths) {
        this((WritableLongList)new LongArray(rows), (WritableIntList)new IntArray(depths), true);
    }

    public ArrayForest(Forest copyFrom) {
        this(copyFrom.getRows(), copyFrom.getDepths());
    }

    public final Forest set(WritableLongList rows, WritableIntList depths, boolean reuseLists) {
        StructureRows.validateForestRowIds((LongList)rows);
        this.myRows = reuseLists ? rows : new LongArray((LongList)rows);
        Object object = this.myDepths = reuseLists ? depths : new IntArray((IntList)depths);
        assert (this.checkInvariants());
        return this;
    }

    public Forest set(LongList rows, IntList depths) {
        return this.set((WritableLongList)new LongArray(rows), (WritableIntList)new IntArray(depths), true);
    }

    boolean checkInvariants() {
        return ArrayForest.checkInvariants(this);
    }

    static boolean checkInvariants(Forest f) {
        String problem = ArrayForest.getDiagnostics(f);
        assert (problem == null) : problem;
        return true;
    }

    public String getDiagnostics() {
        return ArrayForest.getDiagnostics(this);
    }

    public static String getDiagnostics(Forest f) {
        LongList rows = f.getRows();
        IntList depths = f.getDepths();
        int size = rows.size();
        if (size != depths.size()) {
            return "array size mismatch";
        }
        if (size == 0) {
            return null;
        }
        if (depths.get(0) != 0) {
            return "root not at 0 depth";
        }
        HashMap<Long, Integer> rowMap = new HashMap<Long, Integer>();
        int depth = -1;
        for (int i = 0; i < size; ++i) {
            long row = rows.get(i);
            Integer prev = rowMap.put(row, i);
            if (prev != null) {
                return "duplicate row @" + i + " " + row + " " + f;
            }
            int d = depths.get(i);
            if (d < 0) {
                return "bad depth @" + i + " " + d + " " + row + " " + f;
            }
            if (d > depth + 1) {
                return "bad depth change @" + i + " " + depth + " " + d + " " + row + " " + f;
            }
            depth = d;
        }
        return null;
    }

    @Override
    public boolean containsRow(long row) {
        return this.myRows.contains(row);
    }

    public void mergeForest(Forest forest, long under, long after) throws StructureException {
        this.mergeForest(forest, under, after, null);
    }

    public void addForest(long under, long after, Forest forest) {
        try {
            this.mergeForest(forest, under, after);
        }
        catch (StructureException structureException) {
            // empty catch block
        }
    }

    public void clear() {
        assert (this.checkInvariants());
        this.checkModification();
        this.myRows.clear();
        this.myDepths.clear();
    }

    public void mergeForest(Forest forest, long under, long after, @Nullable ForestChangeEventHandler eventHandler) throws StructureException {
        if (forest == null || forest.isEmpty()) {
            return;
        }
        assert (this.checkInvariants());
        assert (ArrayForest.checkInvariants(forest));
        this.checkModification();
        if (this.isMutuallyExclusiveWith(forest)) {
            this.addForestMutuallyExclusive0(forest, under, after, eventHandler);
            return;
        }
        if (under != 0L) {
            int parentIndex;
            int p = parentIndex = this.myRows.indexOf(under);
            while (p >= 0) {
                long pathRow = this.myRows.get(p);
                if (forest.containsRow(pathRow)) {
                    throw new ForestMergeStructureException(under, pathRow, forest, this);
                }
                p = this.getParentIndex(p);
            }
        }
        int size = forest.size();
        int i = 0;
        while (i < size) {
            long nextAfter = forest.getRows().get(i);
            i = this.mergeSubforest(forest, i, under, after, eventHandler);
            after = nextAfter;
        }
        assert (this.checkInvariants());
    }

    public boolean addRow(long row, long under, long after) throws StructureException {
        if (row == 0L) {
            return false;
        }
        StructureRows.validateForestRowId(row);
        int idx = this.indexOf(row);
        if (idx >= 0) {
            this.moveSubtreeAtIndex(idx, under, after, row, null);
            return true;
        }
        this.addForestMutuallyExclusive0(new ArrayForest(row), under, after, null);
        return true;
    }

    private boolean isMutuallyExclusiveWith(Forest forest) {
        return StructureUtil.isMutuallyExclusive(this.getRows(), forest.getRows());
    }

    private int mergeSubforest(Forest forest, int index, long under, long after, ForestChangeEventHandler eventHandler) throws StructureException {
        LongList rows = forest.getRows();
        long row = rows.get(index);
        int thisIndex = this.indexOf(row);
        if (thisIndex >= 0) {
            this.moveSubtreeAtIndex(thisIndex, under, after, row, eventHandler);
        } else {
            this.addForestMutuallyExclusive0(new ArrayForest(row), under, after, eventHandler);
        }
        IntList depths = forest.getDepths();
        int depth = depths.get(index);
        int size = forest.size();
        ++index;
        long subAfter = 0L;
        while (index < size && depths.get(index) > depth) {
            long nextSubAfter = rows.get(index);
            index = this.mergeSubforest(forest, index, row, subAfter, eventHandler);
            subAfter = nextSubAfter;
        }
        return index;
    }

    public void addForestMutuallyExclusive(Forest forest, long under, long after) throws StructureException {
        this.addForestMutuallyExclusive0(forest, under, after, null);
    }

    private int addForestMutuallyExclusive0(Forest forest, long under, long after, ForestChangeEventHandler eventHandler) throws StructureException {
        if (forest == null || forest.isEmpty()) {
            return -1;
        }
        assert (this.checkInvariants());
        assert (ArrayForest.checkInvariants(forest));
        this.checkModification();
        int parentIndex = this.getUnderIndex(under);
        int parentDepth = parentIndex < 0 ? -1 : this.myDepths.get(parentIndex);
        int insertAtIndex = parentIndex + 1;
        int insertAtDepth = parentDepth + 1;
        if (after != 0L) {
            int siblingIndex = this.myRows.indexOf(after);
            if (siblingIndex < 0) {
                logger.info(this + ": ignoring invalid after: " + this.getDebugRowString(after));
            } else if ((siblingIndex = this.getPathIndexAtDepth(siblingIndex, insertAtDepth)) < 0) {
                logger.info(this + ": ignoring invalid after: " + this.getDebugRowString(after) + " not at the right level");
            } else if (parentIndex != this.getParentIndex(siblingIndex)) {
                logger.info(this + ": ignoring invalid after: " + this.getDebugRowString(after) + " not under parent " + this.getDebugRowString(under));
            } else {
                insertAtIndex = this.getSubtreeEnd(siblingIndex);
            }
        }
        LongList rows = forest.getRows();
        IntList depths = forest.getDepths();
        this.myRows.insertAll(insertAtIndex, rows);
        this.myDepths.insertAll(insertAtIndex, depths);
        if (insertAtDepth != 0) {
            for (int i = insertAtIndex + rows.size() - 1; i >= insertAtIndex; --i) {
                this.myDepths.set(i, this.myDepths.get(i) + insertAtDepth);
            }
        }
        if (eventHandler != null) {
            eventHandler.afterForestInserted(this, insertAtIndex, insertAtIndex + rows.size(), forest);
        }
        assert (this.checkInvariants());
        return insertAtIndex;
    }

    private String getDebugRowString(long row) {
        return String.valueOf(row);
    }

    private int getUnderIndex(long under) throws StructureException {
        int parentIndex;
        if (under == 0L) {
            parentIndex = -1;
        } else {
            parentIndex = this.myRows.indexOf(under);
            if (parentIndex < 0) {
                throw StructureErrors.INVALID_FOREST_OPERATION.forRow(under).withMessage("cannot find under " + under + " in " + this);
            }
        }
        return parentIndex;
    }

    @NotNull
    public Forest removeSubtree(long row, ForestChangeEventHandler eventHandler) {
        assert (this.checkInvariants());
        int rowIndex = this.myRows.indexOf(row);
        if (rowIndex < 0) {
            return new ArrayForest();
        }
        return this.removeSubtreeAtIndex(rowIndex, eventHandler);
    }

    @NotNull
    public Forest removeSubtreeAtIndex(int index, @Nullable ForestChangeEventHandler eventHandler) {
        assert (this.checkInvariants());
        this.checkModification();
        int lastIndex = this.getSubtreeEnd(index);
        ArrayForest r = this.copySubtree0(index, lastIndex, false);
        if (eventHandler != null) {
            eventHandler.beforeSubtreeRemoved(this, index, lastIndex, r);
        }
        this.myRows.removeRange(index, lastIndex);
        this.myDepths.removeRange(index, lastIndex);
        assert (this.checkInvariants());
        return r;
    }

    @NotNull
    private ArrayForest copySubtree0(int from, int to, boolean allowForest) {
        LongArray newRows = new LongArray(this.myRows.subList(from, to));
        IntArray newDepths = new IntArray(this.myDepths.subList(from, to));
        int rowDepth = newDepths.get(0);
        if (rowDepth > 0) {
            for (int i = 0; i < newDepths.size(); ++i) {
                int d = newDepths.get(i) - rowDepth;
                if (d < 0 || d == 0 && i > 0 && !allowForest) {
                    throw new IllegalStateException("bad depth " + d + " @ " + i);
                }
                newDepths.set(i, d);
            }
        }
        return new ArrayForest((WritableLongList)newRows, (WritableIntList)newDepths, true);
    }

    @Override
    @NotNull
    public Forest subtree(long row) {
        assert (this.checkInvariants());
        return this.subtreeAtIndex(this.indexOf(row));
    }

    @Override
    @NotNull
    public Forest subtreeAtIndex(int index) {
        assert (this.checkInvariants());
        if (index < 0) {
            return new ArrayForest();
        }
        int lastIndex = this.getSubtreeEnd(index);
        return this.copySubtree0(index, lastIndex, false);
    }

    @Override
    public int getSubtreeEnd(int index) {
        int r;
        if (index < 0) {
            return 0;
        }
        int size = this.myDepths.size();
        if (index > size) {
            return size;
        }
        int d = this.myDepths.get(index);
        for (r = index + 1; r < size && this.myDepths.get(r) > d; ++r) {
        }
        return r;
    }

    @Override
    @Nullable
    public ArrayForest copySubforest(long row) {
        if (row == 0L) {
            return this.copy();
        }
        return this.copySubforestAtIndex(this.indexOf(row));
    }

    @Override
    @Nullable
    public ArrayForest copySubforestAtIndex(int k) {
        if (k < 0) {
            return null;
        }
        int p = this.getSubtreeEnd(k);
        if (p == k + 1) {
            return new ArrayForest();
        }
        return this.copySubtree0(k + 1, p, true);
    }

    @Override
    @NotNull
    public LongList getRows() {
        return this.myRows;
    }

    @Override
    @NotNull
    public IntList getDepths() {
        return this.myDepths;
    }

    @Override
    public long getRow(int index) {
        return this.myRows.get(index);
    }

    @Override
    public int getDepth(int index) {
        return this.myDepths.get(index);
    }

    @Override
    public long getParent(long row) {
        if (row == 0L) {
            return 0L;
        }
        int index = this.myRows.indexOf(row);
        if (index < 0) {
            return 0L;
        }
        int pi = this.getParentIndex(index);
        return pi < 0 ? 0L : this.myRows.get(pi);
    }

    @Override
    public int getParentIndex(int index) {
        if (index < 0) {
            return -1;
        }
        int depth = this.myDepths.get(index);
        if (depth == 0) {
            return -1;
        }
        for (int i = index - 1; i >= 0; --i) {
            if (this.myDepths.get(i) != depth - 1) continue;
            return i;
        }
        assert (false) : index + " " + this;
        return -1;
    }

    @Override
    public int getPathIndexAtDepth(int index, int depth) {
        if (index < 0) {
            return -1;
        }
        if (depth < 0) {
            return -1;
        }
        if (this.myDepths.get(index) < depth) {
            return -1;
        }
        for (int i = index; i >= 0; --i) {
            if (this.myDepths.get(i) != depth) continue;
            return i;
        }
        assert (false) : index + " " + this;
        return -1;
    }

    @Override
    public int getPrecedingSiblingIndex(int index) {
        if (index <= 0) {
            return -1;
        }
        int depth = this.myDepths.get(index);
        for (int i = index - 1; i >= 0; --i) {
            int d = this.myDepths.get(i);
            if (d < depth) {
                return -1;
            }
            if (d != depth) continue;
            return i;
        }
        assert (false) : index + " " + this;
        return -1;
    }

    @Override
    public long getPrecedingSiblingForIndex(int index) {
        return (index = this.getPrecedingSiblingIndex(index)) >= 0 ? this.getRow(index) : 0L;
    }

    @Override
    public long getPrecedingSibling(long row) {
        if (row == 0L) {
            return 0L;
        }
        int index = this.myRows.indexOf(row);
        return this.getPrecedingSiblingForIndex(index);
    }

    @Override
    @NotNull
    public LongArray getPrecedingSiblings(long row) {
        return this.getPrecedingSiblingsForIndex(this.indexOf(row));
    }

    @Override
    @NotNull
    public LongArray getPrecedingSiblingsForIndex(int index) {
        int d;
        LongArray result = new LongArray();
        if (index <= 0) {
            return result;
        }
        int depth = this.myDepths.get(index);
        for (int i = index - 1; i >= 0 && (d = this.myDepths.get(i)) >= depth; --i) {
            if (d != depth) continue;
            result.add(this.myRows.get(i));
        }
        result.reverse();
        return result;
    }

    @Override
    public int getNextSiblingIndex(int index) {
        if (index < 0 || index >= this.size() - 1) {
            return -1;
        }
        int depth = this.myDepths.get(index);
        for (int i = index + 1; i < this.size(); ++i) {
            int d = this.myDepths.get(i);
            if (d < depth) {
                return -1;
            }
            if (d != depth) continue;
            return i;
        }
        return -1;
    }

    @Override
    public long getNextSiblingForIndex(int index) {
        return (index = this.getNextSiblingIndex(index)) >= 0 ? this.getRow(index) : 0L;
    }

    @Override
    public long getNextSibling(long row) {
        if (row == 0L) {
            return 0L;
        }
        int index = this.myRows.indexOf(row);
        return this.getNextSiblingForIndex(index);
    }

    @Override
    @NotNull
    public LongArray getChildren(long row) {
        return row == 0L ? this.getRoots() : this.getChildrenAtIndex(this.indexOf(row));
    }

    @Override
    @NotNull
    public LongArray getChildrenAtIndex(int index) {
        int d;
        LongArray children = new LongArray();
        if (index < 0) {
            return children;
        }
        int depth = this.myDepths.get(index);
        for (int i = index + 1; i < this.myDepths.size() && (d = this.myDepths.get(i)) > depth; ++i) {
            if (d != depth + 1) continue;
            children.add(this.myRows.get(i));
        }
        return children;
    }

    @Override
    @NotNull
    public IntIterator getChildrenIndicesIterator(final int index) {
        return new IntFindingIterator(){
            int i;
            final int forestSize;
            final int parentDepth;
            {
                this.i = index;
                this.forestSize = ArrayForest.this.size();
                this.parentDepth = index < 0 ? -1 : ArrayForest.this.myDepths.get(index);
            }

            protected boolean findNext() {
                while (++this.i < this.forestSize) {
                    int relDepth = ArrayForest.this.myDepths.get(this.i) - this.parentDepth;
                    if (relDepth <= 0) {
                        return false;
                    }
                    if (relDepth != 1) continue;
                    this.myNext = this.i;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    @NotNull
    public LongArray getRoots() {
        LongArray r = new LongArray();
        int size = this.myDepths.size();
        for (int i = 0; i < size; ++i) {
            if (this.myDepths.get(i) != 0) continue;
            r.add(this.myRows.get(i));
        }
        return r;
    }

    @Override
    @NotNull
    public ArrayForest filter(La<Long, ?> filter) {
        if (filter == null) {
            return this;
        }
        int size = this.myRows.size();
        int firstFiltered = this.getFirstNonMatchingRow(filter);
        if (firstFiltered == size) {
            return this;
        }
        LongArray rows = new LongArray(size);
        IntArray depths = new IntArray(size);
        int i = 0;
        while (i < size) {
            i = this.buildFilteredSubtree((WritableLongList)rows, (WritableIntList)depths, i, 0, firstFiltered, filter);
        }
        return new ArrayForest((WritableLongList)rows, (WritableIntList)depths, true);
    }

    private int getFirstNonMatchingRow(La<Long, ?> filter) {
        int firstFiltered;
        int size = this.myRows.size();
        for (firstFiltered = 0; firstFiltered < size && filter.accepts(this.myRows.get(firstFiltered)); ++firstFiltered) {
        }
        return firstFiltered;
    }

    private int buildFilteredSubtree(WritableLongList rows, WritableIntList depths, int index, int targetDepth, int firstFiltered, La<Long, ?> filter) {
        int size = this.myRows.size();
        if (index >= size) {
            return index;
        }
        int rootDepth = this.myDepths.get(index);
        int delta = targetDepth - rootDepth;
        int i = index;
        while (i < size) {
            long nextDepth;
            long row = this.myRows.get(i);
            int depth = this.myDepths.get(i);
            if (depth < rootDepth || depth == rootDepth && i > index) break;
            boolean accepted = i < firstFiltered || i > firstFiltered && filter.accepts(row);
            ++i;
            if (accepted) {
                rows.add(row);
                depths.add(depth + delta);
                continue;
            }
            while (i < size && (nextDepth = (long)this.myDepths.get(i)) > (long)depth) {
                assert (nextDepth == (long)(depth + 1)) : i + " " + depth + " " + nextDepth;
                i = this.buildFilteredSubtree(rows, depths, i, depth + delta, firstFiltered, filter);
            }
        }
        return i;
    }

    @Override
    @NotNull
    public ArrayForest filterSoft(La<Long, ?> filter) {
        int lastFiltered;
        if (filter == null) {
            return this;
        }
        int size = this.myRows.size();
        for (lastFiltered = size - 1; lastFiltered >= 0 && filter.accepts(this.myRows.get(lastFiltered)); --lastFiltered) {
        }
        if (lastFiltered < 0) {
            return this;
        }
        LongArray revRows = new LongArray();
        IntArray revDepth = new IntArray();
        int lastDepth = 0;
        if (lastFiltered < size - 1) {
            revRows.addAll(this.myRows.subList(lastFiltered + 1, size));
            revDepth.addAll(this.myDepths.subList(lastFiltered + 1, size));
            revRows.reverse();
            revDepth.reverse();
            lastDepth = revDepth.get(revDepth.size() - 1);
        }
        for (int i = lastFiltered; i >= 0; --i) {
            boolean passes;
            int depth = this.myDepths.get(i);
            long row = this.myRows.get(i);
            boolean bl = passes = depth < lastDepth || i < lastFiltered && filter.accepts(row);
            if (!passes) continue;
            revRows.add(row);
            revDepth.add(depth);
            lastDepth = depth;
        }
        assert (lastDepth == 0);
        revRows.reverse();
        revDepth.reverse();
        return new ArrayForest((WritableLongList)revRows, (WritableIntList)revDepth, true);
    }

    @Override
    @NotNull
    public ArrayForest filterHardest(La<Long, ?> filter) {
        if (filter == null) {
            return this;
        }
        int size = this.myRows.size();
        int firstFiltered = this.getFirstNonMatchingRow(filter);
        if (firstFiltered == size) {
            return this;
        }
        LongArray rows = new LongArray(size);
        IntArray depths = new IntArray(size);
        int i = 0;
        while (i < size) {
            boolean accepted;
            long row = this.myRows.get(i);
            boolean bl = accepted = i < firstFiltered || i > firstFiltered && filter.accepts(row);
            if (accepted) {
                rows.add(row);
                depths.add(this.myDepths.get(i));
                ++i;
                continue;
            }
            i = this.getSubtreeEnd(i);
        }
        return new ArrayForest((LongList)rows, (IntList)depths);
    }

    @NotNull
    public ArrayForest makeImmutable() {
        this.myImmutable = true;
        return this;
    }

    @Override
    public boolean isImmutable() {
        return this.myImmutable;
    }

    @NotNull
    public static Forest ensureImmutability(@NotNull Forest forest) {
        return forest.isImmutable() ? forest : new ArrayForest(forest).makeImmutable();
    }

    private void checkModification() {
        if (this.myImmutable) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public int size() {
        return this.myRows.size();
    }

    @Override
    @NotNull
    public ArrayForest copy() {
        return new ArrayForest((LongList)this.myRows, (IntList)this.myDepths);
    }

    public boolean moveSubtree(long row, long under, long after) throws StructureException {
        return this.moveSubtree(row, under, after, null);
    }

    public boolean moveSubtree(long row, long under, long after, @Nullable ForestChangeEventHandler eventHandler) throws StructureException {
        assert (this.checkInvariants());
        int idx = this.indexOf(row);
        if (idx < 0) {
            return false;
        }
        this.moveSubtreeAtIndex(idx, under, after, row, eventHandler);
        return true;
    }

    public int moveSubtreeAtIndex(int index, long under, long after, @Nullable ForestChangeEventHandler eventHandler) throws StructureException {
        assert (this.checkInvariants());
        if (index < 0) {
            return -1;
        }
        return this.moveSubtreeAtIndex(index, under, after, this.myRows.get(index), eventHandler);
    }

    private int moveSubtreeAtIndex(int index, long under, long after, long row, ForestChangeEventHandler eventHandler) throws StructureException {
        int underParentIndex;
        assert (this.checkInvariants());
        this.checkModification();
        if (!this.needsMove(row, index, under, after)) {
            return -1;
        }
        int parentIndex = this.getUnderIndex(under);
        if (parentIndex >= 0 && (underParentIndex = this.getPathIndexAtDepth(parentIndex, this.myDepths.get(index))) == index) {
            throw StructureErrors.INVALID_FOREST_OPERATION.withMessage("moved row " + row + " is an ancestor of the destination parent row " + under);
        }
        Forest forest = this.removeSubtreeAtIndex(index, eventHandler);
        int newIndex = this.addForestMutuallyExclusive0(forest, under, after, eventHandler);
        assert (this.checkInvariants());
        assert (newIndex >= 0);
        return newIndex;
    }

    private boolean needsMove(long row, int index, long under, long after) {
        long currUnder;
        int currUnderIndex = this.getParentIndex(index);
        long l = currUnder = currUnderIndex < 0 ? 0L : this.myRows.get(currUnderIndex);
        if (currUnder != under) {
            return true;
        }
        if (after == row) {
            return false;
        }
        int currAfterIndex = this.getPrecedingSiblingIndex(index);
        long currAfter = currAfterIndex < 0 ? 0L : this.myRows.get(currAfterIndex);
        return currAfter != after;
    }

    @Override
    public int indexOf(long row) {
        return row == 0L ? -1 : this.myRows.indexOf(row);
    }

    @Override
    public boolean isEmpty() {
        return this.myRows.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Forest forest = (Forest)o;
        if (!this.myDepths.equals(forest.getDepths())) {
            return false;
        }
        return this.myRows.equals(forest.getRows());
    }

    public int hashCode() {
        int result = this.myRows.hashCode();
        result = 31 * result + this.myDepths.hashCode();
        return result;
    }

    public String toString() {
        return this.toStringLimited(20);
    }

    @Override
    @NotNull
    public String toFullString() {
        return this.toStringLimited(Integer.MAX_VALUE);
    }

    private String toStringLimited(int maxElements) {
        StringBuilder r = new StringBuilder("forest(");
        String prefix = "";
        if (this.myImmutable) {
            r.append("ro");
            prefix = ",";
        }
        int size = this.myRows.size();
        int len = Math.min(maxElements, size);
        for (int i = 0; i < len; ++i) {
            r.append(prefix).append(this.myRows.get(i)).append(':').append(this.myDepths.get(i));
            prefix = ",";
        }
        if (len < size) {
            r.append(" ... [").append(size).append(']');
        }
        r.append(')');
        return r.toString();
    }

    public ArrayForest clone() {
        try {
            ArrayForest copy = (ArrayForest)super.clone();
            copy.myRows = new LongArray((LongList)copy.myRows);
            copy.myDepths = new IntArray((IntList)copy.myDepths);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long getLastChild(long parent) {
        int parentIndex;
        if (parent == 0L) {
            parentIndex = -1;
        } else {
            parentIndex = this.indexOf(parent);
            if (parentIndex < 0) {
                return 0L;
            }
        }
        return this.getLastChildByIndex(parentIndex);
    }

    @Override
    public long getLastChildByIndex(int parentIndex) {
        int d;
        int i;
        int size = this.myDepths.size();
        if (parentIndex >= size) {
            return 0L;
        }
        int depth = parentIndex < 0 ? 0 : this.myDepths.get(parentIndex) + 1;
        int index = -1;
        int n = i = parentIndex < 0 ? 0 : parentIndex + 1;
        while (i < size && (d = this.myDepths.get(i)) >= depth) {
            if (d == depth) {
                index = i;
            }
            ++i;
        }
        return index < 0 ? 0L : this.myRows.get(index);
    }

    @Override
    public <T, C> C foldUpwards(ForestParentChildrenClosure<T, C> closure) {
        if (this.isEmpty()) {
            return null;
        }
        FoldControl fold = new FoldControl();
        Object carry = null;
        while (fold.getIndex() > 0) {
            T result = this.visitUpwards0(fold, 0, closure);
            if (fold.isCancelled()) {
                return null;
            }
            carry = closure.combine(fold, result, carry);
        }
        return carry;
    }

    @Override
    public void scanDownwards(ForestScanner scanner) {
        if (this.isEmpty()) {
            return;
        }
        ScanControl fold = new ScanControl();
        while (fold.getIndex() < this.size()) {
            scanner.acceptRow(fold, this.getRow(fold.getIndex()));
            if (fold.isCancelled()) break;
            fold.advance();
        }
    }

    @Override
    public void visitParentChildrenUpwards(final ForestParentChildrenVisitor visitor) {
        this.foldUpwards(new ForestParentChildrenClosure<Void, Void>(){

            @Override
            public Void combine(@NotNull ForestIterationControl fold, Void value, @Nullable Void carry) {
                return null;
            }

            @Override
            public Void visitRow(@NotNull ForestIterationControl fold, long row, @NotNull LongList subrows, @Nullable Void carry) {
                boolean proceed = visitor.visit(ArrayForest.this, row, subrows);
                if (!proceed) {
                    fold.cancel();
                }
                return null;
            }
        });
    }

    private <T, C> T visitUpwards0(FoldControl fold, int targetDepth, ForestParentChildrenClosure<T, C> closure) {
        int endIndex = fold.getIndex();
        if (endIndex <= 0) {
            return null;
        }
        int depth = this.myDepths.get(endIndex - 1);
        assert (depth >= targetDepth) : depth + " " + targetDepth;
        if (depth == targetDepth) {
            return closure.visitRow(fold, fold.continueUp(depth), LongList.EMPTY, null);
        }
        LongArray children = fold.getChildrenContainer(targetDepth);
        Object carry = null;
        while (fold.getIndex() > 0 && this.myDepths.get(fold.getIndex() - 1) > targetDepth) {
            T result = this.visitUpwards0(fold, targetDepth + 1, closure);
            if (fold.isCancelled()) {
                return null;
            }
            children.add(this.myRows.get(fold.getIndex()));
            assert (fold.getDepth() == targetDepth + 1);
            carry = closure.combine(fold, result, carry);
        }
        assert (fold.getIndex() > 0 && this.myDepths.get(fold.getIndex() - 1) == targetDepth) : fold.getIndex() + " " + this;
        long parent = fold.continueUp(targetDepth);
        children.reverse();
        return closure.visitRow(fold, parent, (LongList)children, carry);
    }

    @Override
    @NotNull
    public LongArray getPath(long row) {
        return this.getPathForIndex(this.indexOf(row));
    }

    @Override
    @NotNull
    public LongArray getPathForIndex(int idx) {
        LongArray r = new LongArray();
        if (idx < 0) {
            return r;
        }
        r.add(this.myRows.get(idx));
        int i = this.getParentIndex(idx);
        while (i >= 0) {
            r.add(this.myRows.get(i));
            i = this.getParentIndex(i);
        }
        r.reverse();
        return r;
    }

    @Override
    @NotNull
    public LongArray getParentPathForIndex(int index) {
        return this.getPathForIndex(this.getParentIndex(index));
    }

    @NotNull
    public Forest removeSubtree(long row) {
        return this.removeSubtree(row, null);
    }

    public void reorder(long parent, LongList children) {
        int to;
        assert (this.checkInvariants());
        this.checkModification();
        int from = -1;
        if (parent != 0L && (from = this.indexOf(parent)) < 0) {
            return;
        }
        int n = to = from < 0 ? this.size() : this.getSubtreeEnd(from);
        if (to == ++from) {
            return;
        }
        int p = from;
        HashMap<Long, Pair> segments = new HashMap<Long, Pair>(children.size());
        while (p < to) {
            int q = this.getSubtreeEnd(p);
            segments.put(this.getRow(p), Pair.pair((Object)p, (Object)q));
            p = q;
        }
        assert (children.size() == segments.size());
        LongArray rows = new LongArray(to - from);
        IntArray depths = new IntArray(to - from);
        for (LongIterator ii : children) {
            long child = ii.value();
            Pair seg = (Pair)segments.get(child);
            if (seg == null) {
                throw new RuntimeException("bad parameter " + children + ", contains " + child + " that is not under " + parent);
            }
            rows.addAll(this.myRows.subList(((Integer)seg.left()).intValue(), ((Integer)seg.right()).intValue()));
            depths.addAll(this.myDepths.subList(((Integer)seg.left()).intValue(), ((Integer)seg.right()).intValue()));
        }
        this.myRows.setAll(from, (LongList)rows);
        this.myDepths.setAll(from, (IntList)depths);
    }

    public void append(Forest forest) {
        this.checkModification();
        if (!this.isMutuallyExclusiveWith(forest)) {
            throw new IllegalArgumentException(this + " is not mutually exclusive with " + forest);
        }
        this.myRows.addAll(forest.getRows());
        this.myDepths.addAll(forest.getDepths());
        assert (this.checkInvariants());
    }

    @NotNull
    public LongIntIterator iterator() {
        return LongIntIterators.pair((LongIterable)this.getRows(), (IntIterable)this.getDepths());
    }

    public void replaceSubtrees(long rowId, Forest forest) {
        this.replaceSubtrees(rowId, forest, false);
    }

    public void replaceSubtreesMutuallyExclusive(long rowId, Forest forest) {
        this.replaceSubtrees(rowId, forest, true);
    }

    public void replaceSubtreesMutuallyExclusiveAtIndex(int index, Forest forest) {
        this.replaceSubtreesAtIndex(index, forest, true);
    }

    private void replaceSubtrees(long rowId, Forest forest, boolean sureMutuallyExclusive) {
        if (rowId == 0L) {
            this.replaceSubtreesAtIndex(-1, forest, sureMutuallyExclusive);
            return;
        }
        int index = this.indexOf(rowId);
        if (index < 0) {
            throw new IllegalArgumentException("row " + rowId + " is not found");
        }
        this.replaceSubtreesAtIndex(index, forest, sureMutuallyExclusive);
    }

    private void replaceSubtreesAtIndex(int index, Forest forest, boolean sureMutuallyExclusive) {
        int endReplaced;
        int startReplaced;
        assert (this.checkInvariants());
        assert (ArrayForest.checkInvariants(forest));
        if (index < -1 || index >= this.size()) {
            throw new IllegalArgumentException("Index is out of bounds: " + index);
        }
        if (index < 0) {
            startReplaced = 0;
            endReplaced = this.myRows.size();
        } else {
            startReplaced = index;
            endReplaced = this.getSubtreeEnd(startReplaced);
            ++startReplaced;
        }
        if (sureMutuallyExclusive) {
            this.replaceRowsMutuallyExclusive(startReplaced, endReplaced, forest);
        } else {
            long rowId = index < 0 ? 0L : this.getRow(index);
            this.replaceRowsWithReallocation(rowId, startReplaced, endReplaced, forest);
        }
        assert (this.checkInvariants());
    }

    private void replaceRowsMutuallyExclusive(int startReplaced, int endReplaced, Forest forest) {
        int addDepth;
        int diff = endReplaced - startReplaced - forest.size();
        if (diff < 0) {
            this.myRows.expand(startReplaced, -diff);
            this.myDepths.expand(startReplaced, -diff);
        } else if (diff > 0) {
            this.myRows.removeRange(startReplaced, startReplaced + diff);
            this.myDepths.removeRange(startReplaced, startReplaced + diff);
        }
        this.myRows.setAll(startReplaced, forest.getRows());
        int n = addDepth = startReplaced > 0 ? this.myDepths.get(startReplaced - 1) + 1 : 0;
        if (addDepth > 0) {
            for (IntIterator it : forest.getDepths()) {
                this.myDepths.set(startReplaced++, it.value() + addDepth);
            }
        } else {
            this.myDepths.setAll(startReplaced, forest.getDepths());
        }
    }

    private void replaceRowsWithReallocation(long rowId, int startReplaced, int endReplaced, Forest forest) {
        int forestSize = this.size();
        int capacity = forestSize - (endReplaced - startReplaced) + forest.size();
        LongArray rows = new LongArray(capacity);
        IntArray depths = new IntArray(capacity);
        LongList preceding = this.myRows.subList(0, startReplaced);
        LongList succeeding = this.myRows.subList(endReplaced, forestSize);
        boolean mutuallyExclusive = StructureUtil.isMutuallyExclusive(forest.getRows(), LongCollections.concatLists((LongList[])new LongList[]{preceding, succeeding}));
        rows.addAll(preceding);
        depths.addAll(this.myDepths.subList(0, startReplaced));
        if (mutuallyExclusive) {
            int addDepth;
            rows.addAll(forest.getRows());
            int n = addDepth = startReplaced > 0 ? this.myDepths.get(startReplaced - 1) + 1 : 0;
            if (addDepth > 0) {
                for (IntIterator ii : forest.getDepths()) {
                    depths.add(ii.value() + addDepth);
                }
            } else {
                depths.addAll(forest.getDepths());
            }
        }
        rows.addAll(succeeding);
        depths.addAll(this.myDepths.subList(endReplaced, forestSize));
        this.set((WritableLongList)rows, (WritableIntList)depths, true);
        if (!mutuallyExclusive) {
            try {
                this.mergeForest(forest, rowId, 0L);
            }
            catch (StructureException structureException) {
                // empty catch block
            }
        }
    }

    private class ScanControl
    extends AbstractIterationControl
    implements ForestScanControl {
        private final IntArray myParentIndexPath;
        private int mySkipIndex;
        private int mySubtreeEnd;

        public ScanControl() {
            super(0);
            this.myParentIndexPath = new IntArray(8);
            this.mySkipIndex = -1;
            this.mySubtreeEnd = 0;
            this.advanceDepthAndPath();
        }

        public void advance() {
            this.advanceIndex();
            this.advanceDepthAndPath();
            this.mySubtreeEnd = 0;
        }

        private void advanceDepthAndPath() {
            if (this.myIndex < ArrayForest.this.size()) {
                this.myDepth = ArrayForest.this.getDepth(this.myIndex);
                int pathElementsToAdd = this.myDepth - this.myParentIndexPath.size() + 1;
                if (pathElementsToAdd > 0) {
                    assert (pathElementsToAdd == 1) : this.myDepth + " " + this.myIndex + " " + this.myParentIndexPath;
                    this.myParentIndexPath.insertMultiple(this.myParentIndexPath.size(), 0, pathElementsToAdd);
                }
                this.myParentIndexPath.set(this.myDepth, this.myIndex);
            } else {
                this.myDepth = 0;
            }
        }

        private void advanceIndex() {
            if (this.mySkipIndex >= 0) {
                if (this.mySkipIndex > this.myIndex) {
                    this.myIndex = this.mySkipIndex;
                } else {
                    assert (false) : this.myIndex + " " + this.mySkipIndex;
                    ++this.myIndex;
                }
                this.mySkipIndex = -1;
            } else {
                ++this.myIndex;
            }
        }

        public int subtreeEnd() {
            if (this.mySubtreeEnd == 0) {
                this.mySubtreeEnd = ArrayForest.this.getSubtreeEnd(this.myIndex);
            }
            return this.mySubtreeEnd;
        }

        @Override
        public long getParent() {
            int parentIndex = this.getParentIndex();
            return parentIndex < 0 ? 0L : ArrayForest.this.getRow(parentIndex);
        }

        @Override
        public int getParentIndex() {
            if (this.myDepth == 0) {
                return -1;
            }
            assert (this.myDepth < this.myParentIndexPath.size()) : this.myDepth + " " + this.myParentIndexPath;
            return this.myParentIndexPath.get(this.myDepth - 1);
        }

        @Override
        public int skipSubtree() {
            this.mySkipIndex = this.subtreeEnd();
            return this.mySkipIndex;
        }

        @Override
        public int skipParentSubtree(int depth) {
            if (depth < -1) {
                throw new IllegalArgumentException("cannot skip to depth " + depth);
            }
            if (depth > this.myDepth) {
                throw new IllegalArgumentException("cannot skip to the same or deeper level " + depth + this);
            }
            int size = ArrayForest.this.myDepths.size();
            if (depth == -1) {
                this.mySkipIndex = size;
            } else {
                this.mySkipIndex = this.myIndex + 1;
                while (this.mySkipIndex < size && ArrayForest.this.myDepths.get(this.mySkipIndex) > depth) {
                    ++this.mySkipIndex;
                }
            }
            return this.mySkipIndex;
        }

        @Override
        public LongList getSubtreeRows() {
            return ArrayForest.this.getRows().subList(this.myIndex, this.subtreeEnd());
        }

        @Override
        public IntList getParentPathIndexes() {
            return this.myParentIndexPath.subList(0, this.myDepth);
        }
    }

    private class FoldControl
    extends AbstractIterationControl {
        private final List<LongArray> myContainerStack;

        public FoldControl() {
            super(ArrayForest.this.size());
            this.myContainerStack = new ArrayList<LongArray>();
        }

        public LongArray getChildrenContainer(int targetDepth) {
            while (this.myContainerStack.size() <= targetDepth) {
                this.myContainerStack.add(new LongArray());
            }
            LongArray r = this.myContainerStack.get(targetDepth);
            r.clear();
            return r;
        }

        public long continueUp(int assertedDepth) {
            assert (this.myIndex > 0);
            --this.myIndex;
            assert (ArrayForest.this.getDepth(this.myIndex) == assertedDepth) : this.myIndex + " " + assertedDepth + " " + ArrayForest.this.getDepth(this.myIndex);
            this.myDepth = assertedDepth;
            return ArrayForest.this.getRow(this.myIndex);
        }
    }

    private abstract class AbstractIterationControl
    implements ForestIterationControl {
        protected int myIndex;
        protected int myDepth;
        private boolean myCancelled;

        public AbstractIterationControl(int initialIndex) {
            this.myIndex = initialIndex;
        }

        public String toString() {
            return "[" + this.getIndex() + ":" + this.getDepth() + "]";
        }

        @Override
        public Forest getForest() {
            return ArrayForest.this;
        }

        @Override
        public void cancel() {
            this.myCancelled = true;
        }

        public boolean isCancelled() {
            return this.myCancelled;
        }

        @Override
        public int getIndex() {
            return this.myIndex;
        }

        @Override
        public int getDepth() {
            return this.myDepth;
        }
    }
}

