/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.auth;

import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.util.CallableE;
import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AuthContext {
    public static final AuthContext CURRENT = new AuthContext(){

        @Override
        @Nullable
        public ApplicationUser getUser() {
            return StructureAuth.getUser();
        }

        @Override
        public boolean isSecurityOverridden() {
            return StructureAuth.isSecurityOverridden();
        }

        @Override
        public <R, E extends Exception> R sudo(@NotNull CallableE<R, E> f) throws E {
            return f.call();
        }
    };

    @Nullable
    public ApplicationUser getUser();

    public boolean isSecurityOverridden();

    public <R, E extends Exception> R sudo(@NotNull CallableE<R, E> var1) throws E;

    public static class Custom
    implements AuthContext {
        @Nullable
        private final ApplicationUser myUser;
        private final boolean mySecurityOverridden;

        public Custom(@Nullable ApplicationUser user, boolean securityOverridden) {
            this.myUser = user;
            this.mySecurityOverridden = securityOverridden;
        }

        @Override
        @Nullable
        public final ApplicationUser getUser() {
            return this.myUser;
        }

        @Override
        public final boolean isSecurityOverridden() {
            return this.mySecurityOverridden;
        }

        @Override
        public final <R, E extends Exception> R sudo(@NotNull CallableE<R, E> f) throws E {
            return StructureAuth.sudo(this.myUser, this.mySecurityOverridden, f);
        }
    }
}

