/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.AttributeCachingStrategy;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeContextDependency;
import com.almworks.jira.structure.api.attribute.loader.ItemAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.ItemAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.TrailItemSet;
import com.almworks.jira.structure.api.attribute.loader.builder.BaseAttributeLoader;
import com.almworks.jira.structure.api.item.ItemIdentity;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseItemAttributeLoader<T>
extends BaseAttributeLoader<T>
implements ItemAttributeLoader<T> {
    @Nullable
    private final Predicate<String> myItemTypeSupportedPredicate;
    @NotNull
    private final BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> myAttributeFunction;
    @Nullable
    private final BiConsumer<Collection<ItemIdentity>, AttributeContext> myPreloadFunction;

    public BaseItemAttributeLoader(@NotNull AttributeSpec<T> attributeSpec, @Nullable Set<AttributeSpec<?>> dependencies, @Nullable Set<AttributeContextDependency> contextDependencies, @Nullable AttributeCachingStrategy cachingStrategy, @Nullable TrailItemSet globalTrail, @Nullable Predicate<String> itemTypeSupportedPredicate, @NotNull BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> attributeFunction, @Nullable BiConsumer<Collection<ItemIdentity>, AttributeContext> preloadFunction) {
        super(attributeSpec, dependencies, contextDependencies, cachingStrategy, globalTrail);
        this.myItemTypeSupportedPredicate = itemTypeSupportedPredicate;
        this.myAttributeFunction = attributeFunction;
        this.myPreloadFunction = preloadFunction;
    }

    @Override
    public boolean isItemTypeSupported(@NotNull String itemType) {
        return this.myItemTypeSupportedPredicate == null || this.myItemTypeSupportedPredicate.test(itemType);
    }

    @Override
    @Nullable
    public AttributeValue<T> loadValue(@NotNull ItemIdentity itemId, @NotNull ItemAttributeContext context) {
        return this.myAttributeFunction.apply(itemId, context);
    }

    @Override
    public void preload(@NotNull Collection<ItemIdentity> itemIds, @NotNull AttributeContext context) {
        if (this.myPreloadFunction != null) {
            this.myPreloadFunction.accept(itemIds, context);
        }
    }
}

