/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.ItemAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.basic.ItemTypeAttributeLoader;
import com.almworks.jira.structure.api.item.ItemIdentity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemClassAttributeLoader<T, A>
extends ItemTypeAttributeLoader<A> {
    private final Class<T> myItemClass;

    public ItemClassAttributeLoader(AttributeSpec<A> spec, Class<T> itemClass, String ... itemTypes) {
        super(spec, itemTypes);
        if (itemClass == null) {
            throw new IllegalArgumentException("item class is not defined");
        }
        this.myItemClass = itemClass;
    }

    @Override
    public AttributeValue<A> loadValue(@NotNull ItemIdentity itemId, @NotNull ItemAttributeContext context) {
        T item = context.getItem(this.myItemClass);
        if (item == null) {
            return AttributeValue.undefined();
        }
        return this.getValue(item, context);
    }

    @Nullable
    protected abstract AttributeValue<A> getValue(@NotNull T var1, @NotNull ItemAttributeContext var2);
}

