/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.sync.util;

import com.almworks.jira.structure.api.util.IndexedForest;
import com.almworks.jira.structure.api.util.LongListHashIndex;
import com.carrotsearch.hppc.IntIntOpenHashMap;

public class HierarchyHelper {
    private final LongListHashIndex myIndex;
    private final IndexedForest myIndexedForest;
    private final IntIntOpenHashMap myMovedIdxs = new IntIntOpenHashMap();

    public HierarchyHelper(LongListHashIndex index, IndexedForest indexedForest) {
        this.myIndex = index;
        this.myIndexedForest = indexedForest;
    }

    public void recordMove(long row, long newParent) {
        this.recordMove(this.myIndex.indexOf(row), this.myIndex.indexOf(newParent));
    }

    private void recordMove(int idx, int newParentIdx) {
        this.myMovedIdxs.put(idx, newParentIdx);
    }

    public long getParent(long row) {
        int parentIndex = this.getParentIndex(row);
        return parentIndex != -1 ? this.myIndexedForest.row(parentIndex) : 0L;
    }

    private int getParentIndex(long row) {
        return this.getParentIndex(this.myIndex.indexOf(row));
    }

    private int getParentIndex(int idx) {
        if (idx == -1) {
            throw new IllegalArgumentException("index is not in the forest");
        }
        return this.myMovedIdxs.containsKey(idx) ? this.myMovedIdxs.lget() : this.myIndexedForest.parent(idx);
    }

    public boolean isInSubtree(long row, long subtreeOwner) {
        if (row == 0L) {
            return false;
        }
        if (subtreeOwner == 0L) {
            return true;
        }
        return this.isInSubtree(this.myIndex.indexOf(row), this.myIndex.indexOf(subtreeOwner));
    }

    private boolean isInSubtree(int idx, int subtreeOwnerIdx) {
        if (idx == -1) {
            throw new IllegalArgumentException("index is not in the forest");
        }
        if (subtreeOwnerIdx == -1) {
            throw new IllegalArgumentException("subtreeOwnerIdx is not in the forest");
        }
        int parentIdx = this.getParentIndex(idx);
        while (parentIdx >= 0) {
            if (parentIdx == subtreeOwnerIdx) {
                return true;
            }
            parentIdx = this.getParentIndex(parentIdx);
        }
        return false;
    }
}

