/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AttributeCachingStrategy;
import com.almworks.jira.structure.api.attribute.loader.AttributeContextDependency;
import com.almworks.jira.structure.api.attribute.loader.DerivedAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.TrailItemSet;
import com.almworks.jira.structure.api.attribute.loader.basic.SimpleDerivedAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.builder.AttributeLoaderBuilder;
import com.almworks.jira.structure.api.item.ItemIdentity;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniDerivedAttributeLoaderBuilder<T, D>
extends AttributeLoaderBuilder<T, UniDerivedAttributeLoaderBuilder<T, D>> {
    private AttributeSpec<D> myDependencySpec;
    private BiFunction<? super D, DerivedAttributeContext, ? extends T> myValueFunction;
    private Function<D, ItemIdentity> myTrailFunction;
    private boolean myYieldOnNull = true;

    public SimpleDerivedAttributeLoader<T, D> build() {
        return new BuiltDerivedLoader<T, D>(UniDerivedAttributeLoaderBuilder.notNull(this.myAttributeSpec, "attributeSpec"), UniDerivedAttributeLoaderBuilder.notNull(this.myDependencySpec, "dependencySpec"), this.myYieldOnNull, UniDerivedAttributeLoaderBuilder.notNull(this.myValueFunction, "derivationFunction"), this.myTrailFunction, UniDerivedAttributeLoaderBuilder.nullableCollectionOfNonNulls(this.buildContextDependencies(), "contextDependencies"), this.myCachingStrategy, this.myGlobalTrail);
    }

    public UniDerivedAttributeLoaderBuilder<T, D> dependency(AttributeSpec<D> dependencySpec) {
        this.myDependencySpec = dependencySpec;
        return this;
    }

    public UniDerivedAttributeLoaderBuilder<T, D> valueFunction(BiFunction<? super D, DerivedAttributeContext, ? extends T> valueFunction) {
        this.myValueFunction = valueFunction;
        return this;
    }

    public UniDerivedAttributeLoaderBuilder<T, D> valueFunction(Function<? super D, ? extends T> valueFunction) {
        return this.valueFunction((? super D d, DerivedAttributeContext ctx) -> valueFunction.apply((Object)d));
    }

    public UniDerivedAttributeLoaderBuilder<T, D> trail(Function<D, ItemIdentity> trailFunction) {
        this.myTrailFunction = trailFunction;
        if (trailFunction != null) {
            this.contextDependency(AttributeContextDependency.TRAIL);
        }
        return this;
    }

    public UniDerivedAttributeLoaderBuilder<T, D> yieldOnNull(boolean yieldOnNull) {
        this.myYieldOnNull = yieldOnNull;
        return this;
    }

    public static class BuiltDerivedLoader<T, D>
    extends SimpleDerivedAttributeLoader<T, D> {
        private final BiFunction<? super D, DerivedAttributeContext, ? extends T> myDerivationFunction;
        private final Function<D, ItemIdentity> myTrailFunction;
        private final Set<AttributeContextDependency> myContextDependencies;
        private final AttributeCachingStrategy myCachingStrategy;
        private final TrailItemSet myGlobalTrail;

        public BuiltDerivedLoader(AttributeSpec<T> spec, AttributeSpec<? extends D> dependency, boolean yield, BiFunction<? super D, DerivedAttributeContext, ? extends T> derivationFunction, Function<D, ItemIdentity> trailFunction, Set<AttributeContextDependency> contextDependencies, AttributeCachingStrategy cachingStrategy, TrailItemSet globalTrail) {
            super(spec, dependency, yield);
            this.myDerivationFunction = derivationFunction;
            this.myTrailFunction = trailFunction;
            this.myContextDependencies = contextDependencies;
            this.myCachingStrategy = cachingStrategy;
            this.myGlobalTrail = globalTrail;
        }

        @Override
        @Nullable
        protected T getValue(@NotNull D value, DerivedAttributeContext context) {
            ItemIdentity trail;
            if (this.myTrailFunction != null && (trail = this.myTrailFunction.apply(value)) != null) {
                context.addTrail(trail);
            }
            return this.myDerivationFunction.apply(value, context);
        }

        @Override
        @Nullable
        public Set<AttributeContextDependency> getContextDependencies() {
            return this.myContextDependencies == null ? super.getContextDependencies() : this.myContextDependencies;
        }

        @Override
        @Nullable
        public AttributeCachingStrategy getCachingStrategy() {
            return this.myCachingStrategy == null ? super.getCachingStrategy() : this.myCachingStrategy;
        }

        @Override
        @Nullable
        public TrailItemSet getGlobalTrail() {
            return this.myGlobalTrail == null ? super.getGlobalTrail() : this.myGlobalTrail;
        }
    }
}

