/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.atlassian.annotations.PublicApi;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public final class ValueFormat<T> {
    public static final ValueFormat<String> HTML = new ValueFormat<String>("html", String.class);
    public static final ValueFormat<String> TEXT = new ValueFormat<String>("text", String.class);
    public static final ValueFormat<String> ID = new ValueFormat<String>("id", String.class);
    public static final ValueFormat<Number> NUMBER = new ValueFormat<Number>("number", Number.class);
    public static final ValueFormat<Boolean> BOOLEAN = new ValueFormat<Boolean>("boolean", Boolean.class);
    public static final ValueFormat<Long> TIME = new ValueFormat<Long>("time", Long.class);
    public static final ValueFormat<Long> DURATION = new ValueFormat<Long>("duration", Long.class);
    public static final ValueFormat<Map> JSON_OBJECT = new ValueFormat<Map>("json", Map.class);
    public static final ValueFormat<List> JSON_ARRAY = new ValueFormat<List>("jsonArray", List.class);
    public static final ValueFormat<Object> ANY = new ValueFormat<Object>("any", Object.class);
    public static final ValueFormat<Comparable> ORDER = new ValueFormat<Comparable>("order", Comparable.class);
    private static final ValueFormat<?>[] STANDARD_FORMATS = new ValueFormat[]{HTML, TEXT, NUMBER, BOOLEAN, DURATION, TIME, JSON_OBJECT, JSON_ARRAY, ORDER, ID, ANY};
    @NotNull
    private final String myFormatId;
    @NotNull
    private final Class<T> myValueClass;

    public ValueFormat(@NotNull String formatId, @NotNull Class<T> valueClass) {
        if (StringUtils.isBlank((CharSequence)formatId)) {
            throw new IllegalArgumentException("format id must not be empty");
        }
        if (formatId.length() > 190) {
            throw new IllegalArgumentException("format id must not be longer than 190 chars");
        }
        if (formatId.indexOf(58) >= 0) {
            throw new IllegalArgumentException("format id must not contain colon");
        }
        if (valueClass == null) {
            throw new IllegalArgumentException("format class must be not null");
        }
        this.myFormatId = formatId;
        this.myValueClass = valueClass;
    }

    @NotNull
    public String getFormatId() {
        return this.myFormatId;
    }

    @NotNull
    public Class<T> getValueClass() {
        return this.myValueClass;
    }

    @NotNull
    public AttributeSpec<T> cast(@NotNull AttributeSpec<?> spec) {
        if (this.equals(spec.getFormat())) {
            return spec;
        }
        throw new ClassCastException("cannot cast attribute " + spec + " as format " + this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myFormatId.equals(((ValueFormat)o).myFormatId);
    }

    public int hashCode() {
        return this.myFormatId.hashCode();
    }

    public String toString() {
        return this.myFormatId;
    }

    @Nullable
    public static ValueFormat<?> getStandardFormat(String formatId) {
        if (formatId == null) {
            return null;
        }
        for (ValueFormat<?> format : STANDARD_FORMATS) {
            if (!format.getFormatId().equals(formatId)) continue;
            return format;
        }
        return null;
    }
}

