/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute;

import com.almworks.jira.structure.api.attribute.AttributeSpecBuilder;
import com.almworks.jira.structure.api.attribute.AttributeSpecNormalization;
import com.almworks.jira.structure.api.attribute.ValueFormat;
import com.almworks.jira.structure.api.util.JsonMapUtil;
import com.almworks.jira.structure.api.util.JsonUtil;
import com.almworks.jira.structure.api.util.SpecParams;
import com.atlassian.annotations.PublicApi;
import java.util.Collections;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
@Immutable
public final class AttributeSpec<T> {
    @NotNull
    private final String myId;
    @NotNull
    private final ValueFormat<T> myFormat;
    @NotNull
    private final Map<String, Object> myParams;
    private transient int myHashCode;
    private transient SpecParams myParamsObject;
    private transient String myStringRepresentation;

    public AttributeSpec(String id, ValueFormat<T> format) {
        this(id, format, null, false);
    }

    public AttributeSpec(@NotNull String id, @NotNull ValueFormat<T> format, @Nullable Map<String, Object> params) {
        this(id, format, params, false);
    }

    AttributeSpec(@NotNull String id, @NotNull ValueFormat<T> format, @Nullable Map<String, Object> params, boolean reuseParams) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("attribute id must not be empty");
        }
        if (id.length() > 190) {
            throw new IllegalArgumentException("attribute id must not be longer than 190 chars");
        }
        if (id.indexOf(58) >= 0) {
            throw new IllegalArgumentException("attribute id must not contain colon");
        }
        if (format == null) {
            throw new IllegalArgumentException("attribute format must not be null");
        }
        this.myId = id;
        this.myFormat = format;
        Map<String, Object> map = reuseParams ? params : JsonMapUtil.copyParameters(params, true, true, true);
        this.myParams = AttributeSpecNormalization.normalizeParams(id, map != null ? map : Collections.emptyMap());
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public ValueFormat<T> getFormat() {
        return this.myFormat;
    }

    @NotNull
    public Map<String, Object> getParamsMap() {
        return this.myParams;
    }

    @NotNull
    public SpecParams getParams() {
        SpecParams paramsObject = this.myParamsObject;
        if (paramsObject == null) {
            this.myParamsObject = paramsObject = new SpecParams(this.myParams);
        }
        return paramsObject;
    }

    public boolean is(String id) {
        return this.myId.equals(id);
    }

    public boolean is(ValueFormat<?> format) {
        return this.myFormat.equals(format);
    }

    public boolean is(String id, ValueFormat<?> format) {
        return this.is(id) && this.is(format);
    }

    public <V> AttributeSpec<V> as(ValueFormat<V> format) {
        return this.is(format) ? format.cast(this) : new AttributeSpec<V>(this.myId, format, this.myParams);
    }

    public AttributeSpec<T> withParam(String name, Object value) {
        return AttributeSpecBuilder.create(this).params().set(name, value).done().build();
    }

    public AttributeSpec<T> replaceParams(Map<String, Object> newParams) {
        return new AttributeSpec<T>(this.getId(), this.getFormat(), newParams, true);
    }

    public AttributeSpec<T> noParams() {
        return new AttributeSpec<T>(this.getId(), this.getFormat());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeSpec that = (AttributeSpec)o;
        if (!this.myFormat.equals(that.myFormat)) {
            return false;
        }
        if (!this.myId.equals(that.myId)) {
            return false;
        }
        return this.myParams.equals(that.myParams);
    }

    public int hashCode() {
        int result = this.myHashCode;
        if (result == 0) {
            result = this.myId.hashCode();
            result = 31 * result + this.myFormat.hashCode();
            this.myHashCode = result = 31 * result + this.myParams.hashCode();
        }
        return result;
    }

    public String toString() {
        String r = this.myStringRepresentation;
        if (r == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.myId);
            if (!this.myParams.isEmpty()) {
                builder.append(':').append(JsonUtil.toJson(this.myParams));
            }
            builder.append(':').append(this.myFormat);
            this.myStringRepresentation = r = builder.toString();
        }
        return r;
    }
}

