/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongCollector;
import com.almworks.integers.LongList;
import com.almworks.integers.LongSizedIterable;
import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.cache.StructureCacheHelper;
import com.almworks.jira.structure.api.error.StructureError;
import com.almworks.jira.structure.api.permissions.CoreAppPermissions;
import com.almworks.jira.structure.api.permissions.StructureAppPermission;
import com.almworks.jira.structure.api.settings.StructureConfiguration;
import com.almworks.jira.structure.api.structure.Structure;
import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.query.Query;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public interface StructurePluginHelper {
    @Nullable
    public StructureError getIssueError(@Nullable Long var1, boolean var2, @Nullable ApplicationUser var3);

    @Nullable
    default public StructureError getIssueError(@Nullable Long issue, boolean checkEdit) {
        return this.getIssueError(issue, checkEdit, StructureAuth.getUser());
    }

    @Contract(value="null, _, _, _ -> !null")
    @Nullable
    public StructureError getIssueError(@Nullable Issue var1, boolean var2, boolean var3, @Nullable ApplicationUser var4);

    @Contract(value="null, _ -> !null")
    @Nullable
    default public StructureError getIssueError(@Nullable Issue issue, boolean checkEdit) {
        return this.getIssueError(issue, checkEdit, false, StructureAuth.getUser());
    }

    @Contract(value="null, _, _ -> !null")
    @Nullable
    default public StructureError getIssueError(@Nullable Issue issue, boolean checkEdit, boolean checkProjectEnabledForStructure) {
        return this.getIssueError(issue, checkEdit, checkProjectEnabledForStructure, StructureAuth.getUser());
    }

    public boolean isProjectStructuredForCurrentUser(@Nullable Project var1);

    default public boolean isStructureAvailableToUser(@Nullable ApplicationUser user) {
        return this.isAllowed(CoreAppPermissions.USE, user);
    }

    default public boolean isStructureAvailableToCurrentUser() {
        return this.isStructureAvailableToUser(StructureAuth.getUser());
    }

    default public boolean isCreateStructureAllowed(@Nullable ApplicationUser user) {
        return this.isAllowed(CoreAppPermissions.CREATE_STRUCTURE, user);
    }

    default public boolean isSynchronizationAllowed(@Nullable ApplicationUser user) {
        return this.isAllowed(CoreAppPermissions.SYNCHRONIZATION, user);
    }

    default public boolean isAutomationAccessAllowed(@Nullable ApplicationUser user) {
        return this.isAllowed(CoreAppPermissions.AUTOMATION, user);
    }

    public boolean isAllowed(@NotNull StructureAppPermission var1, @Nullable ApplicationUser var2);

    default public boolean isAuthenticated() {
        return this.getUser() != null;
    }

    public boolean isAdmin(@Nullable ApplicationUser var1);

    default public boolean isAdmin() {
        return this.isAdmin(this.getUser());
    }

    public boolean isSystemAdmin(@Nullable ApplicationUser var1);

    default public boolean isSystemAdmin() {
        return this.isSystemAdmin(this.getUser());
    }

    public boolean isViewCreationAllowed(@Nullable ApplicationUser var1);

    public boolean isViewSharingAllowed(@Nullable ApplicationUser var1);

    public boolean isIssueEditable(@Nullable Issue var1, @Nullable ApplicationUser var2);

    public boolean hasPermission(@NotNull GlobalPermissionKey var1, @Nullable ApplicationUser var2);

    public boolean hasPermission(@NotNull ProjectPermissionKey var1, @Nullable Issue var2, @Nullable ApplicationUser var3);

    public boolean hasPermission(@NotNull ProjectPermissionKey var1, @Nullable Project var2, @Nullable ApplicationUser var3);

    @Nullable
    public ApplicationUser getUser();

    @NotNull
    public List<Group> getAvailableGroups(@Nullable ApplicationUser var1);

    @NotNull
    default public List<Group> getAvailableGroupsForCurrentUser() {
        return this.getAvailableGroups(this.getUser());
    }

    @NotNull
    public List<ProjectRole> getAvailableRoles();

    @NotNull
    public List<Project> getStructureProjectsForCurrentUser();

    @NotNull
    public List<Project> getProjectsForCurrentUser();

    @NotNull
    public JiraAuthenticationContext getAuthenticationContext();

    @NotNull
    public IssueManager getIssueManager();

    @NotNull
    public PermissionManager getPermissionManager();

    @NotNull
    public PluginAccessor getPluginAccessor();

    @NotNull
    public PluginEventManager getEventManager();

    @NotNull
    public ProjectManager getProjectManager();

    @NotNull
    public ProjectRoleManager getProjectRoleManager();

    @NotNull
    public UserManager getUserManager();

    @NotNull
    public JqlStringSupport getJqlStringSupport();

    @NotNull
    public JqlQueryParser getJqlQueryParser();

    @NotNull
    public SearchService getSearchService();

    @NotNull
    public SessionSearchObjectManagerFactory getSessionSearchObjectManagerFactory();

    @NotNull
    public JqlOperandResolver getJqlOperandResolver();

    @NotNull
    public SearchRequestManager getSearchRequestManager();

    @NotNull
    public GlobalPermissionManager getGlobalPermissionManager();

    @NotNull
    public TimeTrackingConfiguration getTimeTrackingConfiguration();

    @NotNull
    public UserPreferencesManager getUserPreferencesManager();

    @NotNull
    public CustomFieldManager getCustomFieldManager();

    public void requireWidgetResource();

    public void requireLocalizedResource(@NotNull String var1);

    public void requireResource(@NotNull String var1);

    public void requireResourceIfPresent(String var1);

    public void requireIssueDetailsResources();

    public void requireQuickEditResources();

    public void requireIssueShortcuts();

    public void filterInvisibleProjects(@Nullable LongSizedIterable var1, @Nullable ApplicationUser var2, boolean var3, @NotNull LongCollector var4);

    @NotNull
    public LongArray searchQuery(@Nullable String var1) throws SearchException, JqlParseException;

    @NotNull
    public LongArray searchQuery(@Nullable Query var1) throws SearchException;

    @NotNull
    public LongArray searchAndSortQuery(@Nullable String var1) throws SearchException, JqlParseException;

    @NotNull
    public LongArray searchAndSortQuery(@Nullable Query var1) throws SearchException;

    @NotNull
    public LongArray searchAndSortQuery(@Nullable Query var1, int var2) throws SearchException;

    public void matchIssues(@Nullable LongList var1, @Nullable Query var2, boolean var3, @NotNull LongCollector var4) throws SearchException;

    public void matchIssuesSorted(@Nullable LongList var1, @Nullable Query var2, boolean var3, LongCollector var4) throws SearchException;

    public void matchIssuesSorted(@Nullable LongList var1, @Nullable Query var2, boolean var3, @Nullable ApplicationUser var4, boolean var5, LongCollector var6) throws SearchException;

    @NotNull
    public MessageSet validateQuery(ApplicationUser var1, Query var2);

    @Nullable
    default public Query getConfigurationScopeQuery() {
        return this.getConfiguration().getConfigurationScopeQuery();
    }

    @NotNull
    public I18nHelper getI18n(@Nullable ApplicationUser var1);

    @NotNull
    default public I18nHelper getI18n() {
        return this.getI18n(this.getUser());
    }

    @NotNull
    public Comparator<Structure> getStructureComparator(@Nullable ApplicationUser var1);

    @NotNull
    public Collator getCollator(@Nullable ApplicationUser var1);

    @NotNull
    public Locale getLocale();

    public StructureCacheHelper getCacheHelper();

    public boolean isStructureLocked();

    @Nullable
    public Issue getIssue(long var1);

    @Nullable
    public Issue getIssue(String var1);

    @NotNull
    public StructureConfiguration getConfiguration();

    public <T> T instantiate(@NotNull Class<T> var1);
}

