/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.integers.IntArray;
import com.almworks.integers.IntCollector;
import com.almworks.integers.LongArray;
import com.almworks.integers.LongCollector;
import com.almworks.integers.WritableIntList;
import com.almworks.integers.WritableLongList;
import com.almworks.jira.structure.api.forest.raw.ArrayForest;
import com.almworks.jira.structure.api.forest.raw.Forest;
import java.util.function.LongPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RowTree {
    private final Node mySuperRoot = new Node(0L, 0);

    public Node getSuperRoot() {
        return this.mySuperRoot;
    }

    public String toString() {
        return this.mySuperRoot.toFullString();
    }

    public void appendForest(@NotNull Forest forest) {
        this.appendForest(forest, this.mySuperRoot, this.mySuperRoot.getLastChild(), -1, 0, null);
    }

    public void appendForest(@NotNull Forest forest, @NotNull Node underNode, @Nullable Node afterNode) {
        this.appendForest(forest, underNode, afterNode, -1, 0, null);
    }

    public int appendForest(@NotNull Forest forest, @NotNull Node parentNode, @Nullable Node afterNode, int parentIndex, int flags, @Nullable LongPredicate rowFilter) {
        int depth;
        assert (afterNode == null || afterNode.getParent() == parentNode) : parentNode + " " + afterNode;
        int minDepth = parentIndex < 0 ? 0 : forest.getDepth(parentIndex) + 1;
        Node currentNode = afterNode;
        int currentDepth = minDepth;
        if (currentNode == null) {
            currentNode = parentNode;
            --currentDepth;
        }
        int size = forest.size();
        int i = parentIndex + 1;
        while (i < size && (depth = forest.getDepth(i)) >= minDepth) {
            long rowId = forest.getRow(i);
            if (rowFilter != null && !rowFilter.test(rowId)) {
                i = forest.getSubtreeEnd(i);
                continue;
            }
            Node node = this.createNode(rowId, flags);
            if (currentDepth < depth) {
                assert (depth == currentDepth + 1) : "forest invariant broken @" + i + ": depth " + currentDepth + " => " + depth;
                currentNode = currentNode.insertChild(node);
                ++currentDepth;
            } else {
                while (currentDepth > depth) {
                    currentNode = currentNode.getParent();
                    --currentDepth;
                }
                currentNode = currentNode.appendSibling(node);
            }
            ++i;
        }
        return i;
    }

    public Node insertNode(long rowId, int flags, Node parentNode, Node afterNode) {
        return this.insertNaturalizedNode(this.createNode(rowId, flags), parentNode, afterNode);
    }

    public Node moveNode(Node node, Node parentNode, Node afterNode) {
        return this.insertNaturalizedNode(node.pluck(), parentNode, afterNode);
    }

    public void remove(Node node) {
        if (node == this.mySuperRoot) {
            throw new IllegalArgumentException("cannot remove super-root");
        }
        node.pluck();
        this.forgetNode(node);
    }

    public ArrayForest toForest() {
        LongArray rows = new LongArray();
        IntArray depths = new IntArray();
        this.mySuperRoot.writeTo((LongCollector)rows, (IntCollector)depths, -1);
        return new ArrayForest((WritableLongList)rows, (WritableIntList)depths, true);
    }

    protected Node createNode(long rowId, int flags) {
        return new Node(rowId, flags);
    }

    protected void forgetNode(Node node) {
    }

    private Node insertNaturalizedNode(Node node, Node parentNode, Node afterChild) {
        assert (afterChild == null || afterChild.getParent() == parentNode) : parentNode + " " + afterChild;
        if (afterChild != null) {
            afterChild.appendSibling(node);
        } else {
            parentNode.insertChild(node);
        }
        return node;
    }

    public static class Node {
        private final long myRowId;
        private Node myParent;
        private Node myFirstChild;
        private Node myLastChild;
        private Node myNextSibling;
        private Node myPrevSibling;
        private int myFlags;

        private Node(long rowId, int flags) {
            this.myRowId = rowId;
            this.myFlags = flags;
        }

        public String toString() {
            return this.myFlags == 0 ? String.valueOf(this.myRowId) : this.myRowId + "#" + this.myFlags;
        }

        public String toFullString() {
            return this.append(new StringBuilder()).toString();
        }

        public StringBuilder append(StringBuilder sb) {
            if (this.myRowId != 0L) {
                sb.append(this.myRowId);
            }
            if (this.myFirstChild != null) {
                sb.append('(');
                Node n = this.myFirstChild;
                while (n != null) {
                    if (n != this.myFirstChild) {
                        sb.append(',');
                    }
                    n.append(sb);
                    n = n.myNextSibling;
                }
                sb.append(')');
            }
            return sb;
        }

        public long getRowId() {
            return this.myRowId;
        }

        public boolean hasFlags(int flagMask) {
            return (this.myFlags & flagMask) == flagMask;
        }

        public void addFlags(int flagMask) {
            this.myFlags |= flagMask;
        }

        public Node getParent() {
            assert (this.myParent != null);
            return this.myParent;
        }

        public Node getFirstChild() {
            return this.myFirstChild;
        }

        public Node getLastChild() {
            return this.myLastChild;
        }

        public Node getNextSibling() {
            return this.myNextSibling;
        }

        public Node getPrevSibling() {
            return this.myPrevSibling;
        }

        public void writeTo(LongCollector rows, IntCollector depths, int depth) {
            if (depth >= 0) {
                assert (this.myRowId != 0L);
                rows.add(this.myRowId);
                depths.add(depth);
            }
            Node n = this.myFirstChild;
            while (n != null) {
                n.writeTo(rows, depths, depth + 1);
                n = n.myNextSibling;
            }
        }

        public void collectDirectChildren(LongCollector collector) {
            Node n = this.myFirstChild;
            while (n != null) {
                collector.add(n.getRowId());
                n = n.myNextSibling;
            }
        }

        public Node findFirstWithFlags(int flags) {
            if (this.hasFlags(flags)) {
                return this;
            }
            Node n = this.myFirstChild;
            while (n != null) {
                Node r = n.findFirstWithFlags(flags);
                if (r != null) {
                    return r;
                }
                n = n.myNextSibling;
            }
            return null;
        }

        private Node insertChild(Node node) {
            assert (node.myParent == null);
            assert (node.myNextSibling == null);
            assert (node.myPrevSibling == null);
            if (this.myFirstChild == null) {
                assert (this.myLastChild == null);
                this.myLastChild = node;
            } else {
                node.myNextSibling = this.myFirstChild;
                this.myFirstChild.myPrevSibling = node;
            }
            this.myFirstChild = node;
            node.myParent = this;
            return node;
        }

        private Node appendSibling(Node node) {
            assert (node.myParent == null);
            assert (node.myNextSibling == null);
            assert (node.myPrevSibling == null);
            if (this.myNextSibling == null && this.myParent != null) {
                this.myParent.myLastChild = node;
            }
            node.myNextSibling = this.myNextSibling;
            if (this.myNextSibling != null) {
                this.myNextSibling.myPrevSibling = node;
            }
            this.myNextSibling = node;
            node.myPrevSibling = this;
            node.myParent = this.myParent;
            return node;
        }

        private Node pluck() {
            if (this.myPrevSibling != null) {
                this.myPrevSibling.myNextSibling = this.myNextSibling;
            } else {
                this.myParent.myFirstChild = this.myNextSibling;
            }
            if (this.myNextSibling != null) {
                this.myNextSibling.myPrevSibling = this.myPrevSibling;
            } else {
                this.myParent.myLastChild = this.myPrevSibling;
            }
            this.myPrevSibling = null;
            this.myNextSibling = null;
            this.myParent = null;
            return this;
        }
    }
}

