/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class ConsiderateLogger {
    private static long DEFAULT_INTERVAL = TimeUnit.MINUTES.toNanos(5L);
    private final Logger myLogger;
    private final ConcurrentMap<String, SourceStats> myStats = new ConcurrentHashMap<String, SourceStats>();
    private volatile long myInterval = DEFAULT_INTERVAL;

    public ConsiderateLogger(Logger logger) {
        this.myLogger = logger;
    }

    public ConsiderateLogger(Logger logger, long interval) {
        this.myLogger = logger;
        this.myInterval = interval;
    }

    public void info(String source, String message) {
        if (this.acceptSource(source, Level.INFO)) {
            this.myLogger.info(source + " " + message);
        }
    }

    public void info(String source, String message, Throwable throwable) {
        if (this.acceptSource(source, Level.INFO)) {
            this.myLogger.info(source + " " + message, throwable);
        }
    }

    public void warn(String source, String message) {
        if (this.acceptSource(source, Level.WARN)) {
            this.myLogger.warn(source + " " + message);
        }
    }

    public void warn(String source, String message, Throwable throwable) {
        if (this.acceptSource(source, Level.WARN)) {
            this.myLogger.warn(source + " " + message, throwable);
        }
    }

    private boolean acceptSource(String source, Level level) {
        SourceStats stats = (SourceStats)this.myStats.get(source);
        if (stats == null) {
            stats = new SourceStats(source, level);
            this.myStats.putIfAbsent(source, stats);
        }
        return stats.isAcceptable();
    }

    public void reset() {
        this.myStats.clear();
    }

    public void setInterval(long interval) {
        this.myInterval = interval;
    }

    private class SourceStats {
        private final String mySource;
        private final AtomicInteger myCount = new AtomicInteger();
        private final Level myLevel;
        private volatile long myLastLogTime;

        public SourceStats(String source, Level level) {
            this.mySource = source;
            this.myLevel = level;
        }

        public boolean isAcceptable() {
            long now = System.nanoTime();
            if (this.myLastLogTime != 0L && now - this.myLastLogTime <= ConsiderateLogger.this.myInterval) {
                this.myCount.incrementAndGet();
                return false;
            }
            this.myLastLogTime = now;
            int count = this.myCount.getAndSet(0);
            if (count > 0) {
                switch (this.myLevel) {
                    case INFO: {
                        ConsiderateLogger.this.myLogger.info(count + " info log entries from " + this.mySource + " were not shown");
                        break;
                    }
                    default: {
                        ConsiderateLogger.this.myLogger.warn(count + " warnings from " + this.mySource + " were not shown");
                    }
                }
            }
            return true;
        }
    }

    private static enum Level {
        INFO,
        WARN;

    }
}

