/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.settings;

import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongList;
import com.almworks.jira.structure.api.permissions.CoreAppPermissions;
import com.almworks.jira.structure.api.permissions.PermissionSubject;
import com.almworks.jira.structure.api.permissions.StructureAppPermission;
import com.almworks.jira.structure.api.settings.AttributeSensitivitySettings;
import com.almworks.jira.structure.api.settings.UISettings;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StructureConfiguration {
    public boolean isEnabledForAllProjects();

    @NotNull
    public LongList getPickedProjectIds();

    @NotNull
    public List<Project> getPickedProjects();

    @NotNull
    public List<Project> getCurrentlyEnabledProjects();

    public boolean isProjectEnabled(@Nullable Project var1);

    default public boolean isEnabledForAnyone() {
        return this.isAllowedForAnyone(CoreAppPermissions.USE);
    }

    @NotNull
    default public List<PermissionSubject> getEnabledPermissionSubjects() {
        return this.getPermissionSubjects(CoreAppPermissions.USE);
    }

    default public boolean isCreateEnabledForAnyone() {
        return this.isAllowedForAnyone(CoreAppPermissions.CREATE_STRUCTURE);
    }

    @NotNull
    default public List<PermissionSubject> getCreatorPermissionSubjects() {
        return this.getPermissionSubjects(CoreAppPermissions.CREATE_STRUCTURE);
    }

    default public boolean isSynchronizationEnabledForAnyone() {
        return this.isAllowedForAnyone(CoreAppPermissions.SYNCHRONIZATION);
    }

    @NotNull
    default public List<PermissionSubject> getSynchronizationPermissionSubjects() {
        return this.getPermissionSubjects(CoreAppPermissions.SYNCHRONIZATION);
    }

    default public boolean isAutomationEnabledForAnyone() {
        return this.isAllowedForAnyone(CoreAppPermissions.AUTOMATION);
    }

    @NotNull
    default public List<PermissionSubject> getAutomationPermissionSubjects() {
        return this.getPermissionSubjects(CoreAppPermissions.AUTOMATION);
    }

    public void setEnabledForAllProjects(boolean var1);

    public void setPickedProjectIds(@Nullable String var1);

    default public void setPickedProjectIds(@Nullable LongIterable projectIds) {
        if (projectIds == null) {
            this.setPickedProjectIds("");
            return;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (LongIterator it : projectIds) {
            joiner.add(Long.toString(it.value()));
        }
        this.setPickedProjectIds(joiner.toString());
    }

    default public void setPickedProjectIds(@Nullable Collection<Long> projectIds) {
        this.setPickedProjectIds(projectIds == null ? "" : projectIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
    }

    default public void setEnabledForAnyone(boolean enabled) {
        this.setAllowedForAnyone(CoreAppPermissions.USE, enabled);
    }

    default public void setEnabledPermissionSubjectsEncoded(@Nullable String subjects) {
        this.setPermissionSubjectsEncoded(CoreAppPermissions.USE, subjects);
    }

    default public void setCreateEnabledForAnyone(boolean enabled) {
        this.setAllowedForAnyone(CoreAppPermissions.CREATE_STRUCTURE, enabled);
    }

    default public void setCreatorPermissionSubjectsEncoded(@Nullable String subjects) {
        this.setPermissionSubjectsEncoded(CoreAppPermissions.CREATE_STRUCTURE, subjects);
    }

    default public void setSynchronizationEnabledForAnyone(boolean enabled) {
        this.setAllowedForAnyone(CoreAppPermissions.SYNCHRONIZATION, enabled);
    }

    default public void setSynchronizationPermissionSubjectsEncoded(@Nullable String subjects) {
        this.setPermissionSubjectsEncoded(CoreAppPermissions.SYNCHRONIZATION, subjects);
    }

    default public void setAutomationEnabledForAnyone(boolean enabled) {
        this.setAllowedForAnyone(CoreAppPermissions.AUTOMATION, enabled);
    }

    default public void setAutomationPermissionSubjectsEncoded(@Nullable String subjects) {
        this.setPermissionSubjectsEncoded(CoreAppPermissions.AUTOMATION, subjects);
    }

    @NotNull
    public JqlClauseBuilder addConfigurationScopeClause(@Nullable JqlClauseBuilder var1);

    @Nullable
    public Query getConfigurationScopeQuery();

    public boolean isStructureAvailable(@Nullable ApplicationUser var1);

    default public boolean isStructureCreationAllowed(@Nullable ApplicationUser user) {
        return this.isAllowed(CoreAppPermissions.CREATE_STRUCTURE, user);
    }

    default public boolean isSynchronizationAllowed(@Nullable ApplicationUser user) {
        return this.isAllowed(CoreAppPermissions.SYNCHRONIZATION, user);
    }

    default public boolean isAutomationAccessAllowed(@Nullable ApplicationUser user) {
        return this.isAllowed(CoreAppPermissions.AUTOMATION, user);
    }

    public boolean isAllowedForAnyone(@NotNull StructureAppPermission var1);

    @NotNull
    public List<PermissionSubject> getPermissionSubjects(@NotNull StructureAppPermission var1);

    public void setAllowedForAnyone(@NotNull StructureAppPermission var1, boolean var2);

    public void setPermissionSubjectsEncoded(@NotNull StructureAppPermission var1, @Nullable String var2);

    default public void setPermissionSubjects(@NotNull StructureAppPermission permission, @Nullable Collection<? extends PermissionSubject> subjects) {
        this.setPermissionSubjectsEncoded(permission, subjects == null ? "" : subjects.stream().map(PermissionSubject::toEncodedString).collect(Collectors.joining(",")));
    }

    public boolean isAllowed(@NotNull StructureAppPermission var1, @Nullable ApplicationUser var2);

    public long getDefaultStructureId(@Nullable Project var1);

    public void setDefaultStructureId(@Nullable Project var1, @Nullable Long var2);

    public boolean isDefaultStructureSetForProject(@NotNull Project var1);

    @NotNull
    public UISettings getUISettings(@Nullable ApplicationUser var1, @Nullable Project var2);

    public void setUISettings(@Nullable ApplicationUser var1, @Nullable Project var2, @NotNull UISettings var3);

    public void clearUISettings(@Nullable ApplicationUser var1, @Nullable Project var2);

    @NotNull
    public AttributeSensitivitySettings getAttributeSensitivitySettings();

    public void setAttributeSensitivitySettings(@NotNull AttributeSensitivitySettings var1);
}

